/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;

public class TimeZones {
    public static final String GMT_ID = "GMT";
    public static final TimeZone GMT = TimeZones.getTimeZone("GMT");
    private static final boolean JAVA_25 = SystemUtils.isJavaVersionAtLeast(JavaVersion.JAVA_25);

    public static TimeZone getTimeZone(String id) {
        return TimeZone.getTimeZone(JAVA_25 && TimeZones.mapShortIDs() ? ZoneId.SHORT_IDS.getOrDefault(id, id) : id);
    }

    private static boolean mapShortIDs() {
        return SystemProperties.getBoolean(TimeZones.class, "mapShortIDs", () -> true);
    }

    public static TimeZone toTimeZone(TimeZone timeZone) {
        return (TimeZone)((Object)ObjectUtils.getIfNull(timeZone, TimeZone::getDefault));
    }

    private TimeZones() {
    }
}

