/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.SystemEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandlerImpl
extends ExceptionHandler {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "faces.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "faces.context.exception.handler.log_after";
    private static final String LOG_KEY = "faces.context.exception.handler.log";
    public static final Level INCIDENT_ERROR = Level.parse(Integer.toString(Level.SEVERE.intValue() + 100));
    private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
    private LinkedList<ExceptionQueuedEvent> handledExceptions;
    private ExceptionQueuedEvent handled;
    private boolean errorPagePresent;
    private final Set<Class<? extends Throwable>> exceptionTypesToIgnoreInLogging;

    public ExceptionHandlerImpl() {
        this(FacesContext.getCurrentInstance(), true);
    }

    public ExceptionHandlerImpl(FacesContext context, boolean errorPagePresent) {
        this.errorPagePresent = errorPagePresent;
        this.exceptionTypesToIgnoreInLogging = ExceptionHandlerImpl.parseExceptionTypesToIgnoreInLogging(context);
    }

    @Override
    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() throws FacesException {
        Iterator<ExceptionQueuedEvent> i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            try {
                Throwable t = context.getException();
                Throwable unwrapped = this.getRootCause(t);
                boolean loggable = this.isLoggable(unwrapped);
                if (this.isRethrown(t)) {
                    this.handled = event;
                    if (unwrapped != null) {
                        this.throwIt(context.getContext(), new FacesException(unwrapped.getMessage(), unwrapped));
                    } else if (t instanceof FacesException) {
                        this.throwIt(context.getContext(), (FacesException)t);
                    } else {
                        this.throwIt(context.getContext(), new FacesException(t.getMessage(), t));
                    }
                    if (!loggable || !LOGGER.isLoggable(INCIDENT_ERROR)) continue;
                    this.log(context);
                    continue;
                }
                if (!loggable) continue;
                this.log(context);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(event);
                i.remove();
            }
        }
    }

    @Override
    public boolean isListenerForSource(Object source) {
        return source instanceof ExceptionQueuedEventContext;
    }

    @Override
    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionQueuedEvent)event);
        }
    }

    @Override
    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        if (this.shouldUnwrap(t.getClass())) {
            Throwable root = t.getCause();
            if (root != null) {
                Throwable tmp = this.getRootCause(root);
                if (tmp == null) {
                    return root;
                }
                return tmp;
            }
            return t;
        }
        return t;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private static Set<Class<? extends Throwable>> parseExceptionTypesToIgnoreInLogging(FacesContext context) {
        HashSet types = new HashSet();
        String typesParam = WebConfiguration.getInstance(context.getExternalContext()).getOptionValue(WebConfiguration.WebContextInitParameter.ExceptionTypesToIgnoreInLogging);
        if (typesParam != null) {
            for (String typeParam : Util.split(context.getExternalContext().getApplicationMap(), typesParam, ",")) {
                try {
                    types.add(Class.forName(typeParam));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format("Context parameter '%s' references a class which cannot be found in runtime classpath: '%s'", WebConfiguration.WebContextInitParameter.ExceptionTypesToIgnoreInLogging.getQualifiedName(), typeParam), e);
                }
            }
        }
        return Collections.unmodifiableSet(types);
    }

    private void throwIt(FacesContext ctx, FacesException fe) {
        Throwable wrapped;
        ExternalContext extContext;
        boolean isDevelopment;
        block6: {
            isDevelopment = ctx.isProjectStage(ProjectStage.Development);
            extContext = ctx.getExternalContext();
            wrapped = fe.getCause();
            try {
                extContext.responseReset();
            }
            catch (Exception e) {
                boolean isConnectionAbort;
                boolean bl = isConnectionAbort = wrapped instanceof IOException && Util.isConnectionAbort((IOException)wrapped);
                if (isConnectionAbort || !LOGGER.isLoggable(Level.WARNING)) break block6;
                LOGGER.log(Level.WARNING, "Exception when handling error trying to reset the response.", wrapped);
            }
        }
        if (null != wrapped && wrapped instanceof FacesFileNotFoundException) {
            extContext.setResponseStatus(404);
        } else {
            extContext.setResponseStatus(500);
        }
        if (!isDevelopment || this.errorPagePresent) {
            if (isDevelopment) {
                ctx.getExternalContext().getRequestMap().put("com.sun.faces.error.view", ctx.getViewRoot());
            }
            throw fe;
        }
        RenderKitUtils.renderHtmlErrorPage(ctx, fe);
    }

    private boolean shouldUnwrap(Class<? extends Throwable> c) {
        return FacesException.class.equals(c) || ELException.class.equals(c);
    }

    private boolean isRethrown(Throwable t) {
        return !(t instanceof AbortProcessingException);
    }

    private boolean isLoggable(Throwable unwrapped) {
        return this.exceptionTypesToIgnoreInLogging.stream().noneMatch(type -> type.isInstance(unwrapped));
    }

    private void log(ExceptionQueuedEventContext exceptionContext) {
        Level level;
        UIComponent c = exceptionContext.getComponent();
        boolean beforePhase = exceptionContext.inBeforePhase();
        boolean afterPhase = exceptionContext.inAfterPhase();
        PhaseId phaseId = exceptionContext.getPhaseId();
        Throwable t = exceptionContext.getException();
        String key = this.getLoggingKey(beforePhase, afterPhase);
        Level level2 = level = LOGGER.isLoggable(INCIDENT_ERROR) && LOGGER.isLoggable(Level.SEVERE) ? INCIDENT_ERROR : Level.SEVERE;
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
            if (t.getMessage() != null) {
                LOGGER.log(level, t.getMessage(), t);
            } else {
                LOGGER.log(level, "No associated message", t);
            }
        }
    }

    private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
        if (beforePhase) {
            return LOG_BEFORE_KEY;
        }
        if (afterPhase) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

