/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.search.QueryContext;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.ext.search.SearchContextImpl;
import org.apache.cxf.message.Message;

@Provider
public class QueryContextProvider
implements ContextProvider<QueryContext> {
    public QueryContext createContext(Message message) {
        return new QueryContextImpl(message);
    }

    private static class QueryContextImpl
    implements QueryContext {
        private SearchContext searchContext;
        private Message message;

        QueryContextImpl(Message message) {
            this.searchContext = new SearchContextImpl(message);
            this.message = message;
        }

        @Override
        public <T> String getConvertedExpression(Class<T> beanClass) {
            return this.getConvertedExpression((String)null, beanClass);
        }

        @Override
        public <T, E> E getConvertedExpression(Class<T> beanClass, Class<E> queryClass) {
            return this.getConvertedExpression(null, beanClass, queryClass);
        }

        @Override
        public <T> String getConvertedExpression(String originalExpression, Class<T> beanClass) {
            return this.getConvertedExpression(originalExpression, beanClass, String.class);
        }

        @Override
        public <T, E> E getConvertedExpression(String originalExpression, Class<T> beanClass, Class<E> queryClass) {
            SearchConditionVisitor visitor = this.getVisitor();
            if (visitor == null) {
                return null;
            }
            SearchCondition<T> cond = this.searchContext.getCondition(originalExpression, beanClass);
            if (cond == null) {
                return null;
            }
            cond.accept(visitor);
            return queryClass.cast(visitor.getQuery());
        }

        private <T, Y> SearchConditionVisitor<T, Y> getVisitor() {
            Object visitor = this.message.getContextualProperty("search.visitor");
            if (visitor == null) {
                return null;
            }
            return (SearchConditionVisitor)visitor;
        }
    }
}

