/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.javax;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.nio.ByteBuffer;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.javax.JavaxUpgradeHttpRequest;
import org.apache.wicket.protocol.ws.javax.JavaxWebSocketConnection;

public class JavaxWebSocketProcessor
extends AbstractWebSocketProcessor {
    public JavaxWebSocketProcessor(Session session, WebApplication application, EndpointConfig endpointConfig) {
        super((HttpServletRequest)new JavaxUpgradeHttpRequest(session, endpointConfig), application);
        this.onConnect((IWebSocketConnection)new JavaxWebSocketConnection(session, this));
        session.addMessageHandler((MessageHandler)new StringMessageHandler());
        session.addMessageHandler((MessageHandler)new BinaryMessageHandler());
    }

    public void onOpen(Object containerConnection) {
    }

    private class StringMessageHandler
    implements MessageHandler.Whole<String> {
        private StringMessageHandler() {
        }

        public void onMessage(String message) {
            JavaxWebSocketProcessor.this.onMessage(message);
        }
    }

    private class BinaryMessageHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private BinaryMessageHandler() {
        }

        public void onMessage(ByteBuffer message) {
            byte[] array = message.array();
            JavaxWebSocketProcessor.this.onMessage(array, 0, array.length);
        }
    }
}

