/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Objects;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.ISubresourceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceType;
import org.apache.wicket.markup.html.CrossOrigin;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.value.AttributeMap;

public abstract class AbstractJavaScriptReferenceHeaderItem
extends JavaScriptHeaderItem
implements ISubresourceHeaderItem {
    private boolean async;
    private boolean defer;
    private String charset;
    private CrossOrigin crossOrigin;
    private String integrity;
    private JavaScriptReferenceType type = JavaScriptReferenceType.TEXT_JAVASCRIPT;

    public boolean isAsync() {
        return this.async;
    }

    public AbstractJavaScriptReferenceHeaderItem setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public AbstractJavaScriptReferenceHeaderItem setDefer(boolean defer) {
        this.defer = defer;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public AbstractJavaScriptReferenceHeaderItem setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public CrossOrigin getCrossOrigin() {
        return this.crossOrigin;
    }

    @Override
    public AbstractJavaScriptReferenceHeaderItem setCrossOrigin(CrossOrigin crossOrigin) {
        this.crossOrigin = crossOrigin;
        return this;
    }

    @Override
    public String getIntegrity() {
        return this.integrity;
    }

    @Override
    public AbstractJavaScriptReferenceHeaderItem setIntegrity(String integrity) {
        this.integrity = integrity;
        return this;
    }

    public JavaScriptReferenceType getType() {
        return this.type;
    }

    public AbstractJavaScriptReferenceHeaderItem setType(JavaScriptReferenceType type) {
        this.type = type;
        return this;
    }

    protected final void internalRenderJavaScriptReference(Response response, String url) {
        Args.notEmpty(url, "url");
        AttributeMap attributes = this.createAttributeMap(url);
        JavaScriptUtils.writeScript(response, attributes);
    }

    final AttributeMap createAttributeMap(String url) {
        AttributeMap attributes = new AttributeMap();
        JavaScriptReferenceType type = this.getType();
        if (type != null) {
            attributes.putAttribute("type", type.getType());
        }
        attributes.putAttribute("id", this.getId());
        attributes.putAttribute("defer", this.defer);
        attributes.putAttribute("charset", this.charset);
        attributes.putAttribute("async", this.async);
        attributes.putAttribute("src", url);
        attributes.putAttribute("nonce", this.getNonce());
        attributes.putAttribute("crossOrigin", this.getCrossOrigin() == null ? null : this.getCrossOrigin().getRealName());
        attributes.putAttribute("integrity", this.getIntegrity());
        return attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractJavaScriptReferenceHeaderItem that = (AbstractJavaScriptReferenceHeaderItem)o;
        return this.async == that.async && this.defer == that.defer && Objects.equals(this.charset, that.charset) && Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.async ? 1 : 0);
        result = 31 * result + (this.defer ? 1 : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

