## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::identifier::lc31;

our $DATE = '2025-11-11'; # DATE
our $VERSION = '0.002'; # VERSION

our $rschema = do{my$var={base=>"identifier::lc",clsets_after_base=>[{description=>"\nJust like C<identifier::lc>, but limited to 31 characters.\n\n",examples=>[{valid=>1,value=>"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"},{summary=>"Too long",valid=>0,value=>"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}],max_len=>31,summary=>"Lowercase Identifier with a maximum length of 31 characters"}],clsets_after_type=>[{description=>"\nJust like C<identifier>, but must contain lowercase [a-z] only.\n\n",examples=>[{summary=>"Not a string",valid=>0,value=>{}},{summary=>"Empty string",valid=>0,value=>""},{valid=>1,value=>"a"},{valid=>1,value=>"a1"},{summary=>"Contains uppercase letter",valid=>0,value=>"Aa"},{valid=>1,value=>"a_"},{valid=>1,value=>"_a"},{valid=>1,value=>"a__b"},{summary=>"Contains whitespace",valid=>0,value=>"a b"},{summary=>"Contains invalid character",valid=>0,value=>"ab-"}],match=>qr(\A[a-z_][a-z0-9_]*\z),min_len=>1,summary=>"A string that starts with [a-z_] followed by zero of more [a-z0-9_]"},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_base}[0]'],resolve_path=>["str","identifier::lc"],type=>"str",v=>2};$var->{clsets_after_type}[1]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Lowercase Identifier with a maximum length of 31 characters

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::identifier::lc31 - Lowercase Identifier with a maximum length of 31 characters

=head1 VERSION

This document describes version 0.002 of Sah::SchemaR::identifier::lc31 (from Perl distribution Sah-SchemaBundle-Identifier), released on 2025-11-11.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-Identifier>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-Identifier>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-Identifier>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
