#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Islanders
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251001.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='islanders'
GAME_NAME='Islanders'

ARCHIVE_BASE_0_NAME='setup_islanders_1.04_(69301).exe'
ARCHIVE_BASE_0_MD5='a0172c90a8894ba6972f8c50f1587c44'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='653528'
ARCHIVE_BASE_0_VERSION='1.04-gog69301'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/islanders'

UNITY3D_NAME='islanders'

CONTENT_PATH_DEFAULT='.'
## The game crashes after displaying intro logos if this GOG Galaxy file is missing.
CONTENT_GAME0_BIN_FILES='
galaxyconfig.json'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Coatsink/ISLANDERS'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# dos2unix is used to edit a configuration file, to prevent a delay on game launch.
REQUIREMENTS_LIST='
dos2unix'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Prevent a delay on game launch.

galaxy_config="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/galaxyconfig.json"
dos2unix --quiet "$galaxy_config"
sed --in-place --expression='s/"client_code": ".*"/&,\n  "auth_timeout": 1/' "$galaxy_config"
unix2dos --quiet "$galaxy_config"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
