import { Reporter } from "../reporter";
import { Arbitrator, Goal, Json, OrderGoalTypeList, PreBuildContext, Progress, Rule } from "./interface";
import ProgressImpl from "./progress-impl";
interface Objective<A extends any[]> {
    goal: Goal<any, A>;
    matchResult: A;
    progress: ProgressImpl<Json>;
}
export declare function SleepPromise(dt: number): Promise<null>;
export default class Director implements Arbitrator {
    reporter: Reporter;
    private rules;
    private database;
    private journal;
    private someTargetWrong;
    buildRev: number;
    private updateBuildRev;
    private createObjective;
    private createProgress;
    ruleNotFound(id: string): import("../errors").ExtError;
    dependencyNotFound(id: string, against: string): import("../errors").ExtError;
    tryToBuildWithDifferentRule(id: string): import("../errors").ExtError;
    cancelled(id: string): import("../errors").ExtError;
    BuildCancelledByUser(): import("../errors").ExtError;
    getProgress(goalID: string): ProgressImpl<Json> | ProgressImpl<any>;
    queryGoal(isName: boolean, name: string, args?: null | undefined | string[]): Objective<any> | undefined;
    validateGoal<A extends any[]>(goal: Goal<any, A>): undefined | Objective<A>;
    private checkNeedRebuild;
    checkTriggerRebuildByDependency<A extends any[]>(dep: Objective<A>, against: Objective<A>): Promise<boolean>;
    materialBuildNewTarget<A extends any[]>(target: Objective<A>): Promise<any>;
    private buildNewTarget;
    buildTarget<A extends any[]>(target: Objective<A>): Promise<any>;
    want(...args: OrderGoalTypeList): Promise<any[]>;
    userCancelSync(): import("../errors").ExtError;
    addRule<T, A extends any[]>(rule: Rule<T, A>): void;
    invalidateJournal(): void;
    reset(): void;
    fromJson(json: any): any;
    toJson(): any;
    private lock;
    setCapacity(cap: number): void;
    start<T>(p: Progress<T>): Promise<void>;
    end<T>(p: Progress<T>, err: null | Error): Promise<void>;
    unhalt<T>(p: Progress<T>): Promise<void>;
    halt<T>(p: Progress<T>): Promise<void>;
}
export declare class PreBuildContextImpl implements PreBuildContext<any> {
    private objective;
    private director;
    constructor(obj: Objective<any>, resolver: Director);
    get id(): string;
    toString(): string;
    get dependencies(): import("./interface").Dependency[][];
    get isVolatile(): boolean;
    get lastResult(): Json | undefined;
    dependencyModified(): Promise<boolean>;
    cutoffEarly(): Promise<boolean>;
}
export {};
