/// <reference path="../../../src/bez-tool/boolean/clipper-lib.d.ts" />
import * as ClipperLib from "clipper-lib";
import { Arcs } from "../../derivable";
import { Bez3Slice } from "../shared/slice-arc";
export type combineOps = {
    type: "operand";
    fillType: ClipperLib.PolyFillType;
    shape: Arcs.Bez3[][];
} | {
    type: "operator";
    operator: ClipperLib.ClipType;
};
export type combineOpsInternal = combineOps | {
    type: "operand_rectified";
    fillType: ClipperLib.PolyFillType;
    shape_rectified: Bez3Slice[][];
    intersectionTs: number[][];
} | {
    type: "operand_poly";
    fillType: ClipperLib.PolyFillType;
    shape_poly: ClipperLib.IntPoint[][];
};
export type StackItem = {
    operand: ClipperLib.IntPoint[][];
    fillType: ClipperLib.PolyFillType;
};
export declare function combineStack(ops: combineOps[], resolution?: number): Bez3Slice[][];
export declare function combine(op: ClipperLib.ClipType, s1: Arcs.Bez3[][], s2: Arcs.Bez3[][], rule1: ClipperLib.PolyFillType, rule2: ClipperLib.PolyFillType, RESOLUTION?: number): Bez3Slice[][];
export declare function removeOverlap(s1: Arcs.Bez3[][], rule: ClipperLib.PolyFillType, RESOLUTION?: number): Bez3Slice[][];
export { ClipType, PolyFillType } from "clipper-lib";
