"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelfTracking = SelfTracking;
const interface_1 = require("../core/interface");
const matchers_1 = require("./matchers");
const rule_base_1 = require("./rule-base");
const util_1 = require("./util");
class SelfTrackingRule extends rule_base_1.RuleBase {
    constructor(matcher, FRecipe) {
        super(matcher);
        this.FRecipe = FRecipe;
        this.kindTag = "Builtin::Meta::SelfTrackingRule";
        this.isUser = false;
    }
    async build(t, ...args) {
        const result = await this.FRecipe(t, ...args);
        t.is.modified();
        return result;
    }
    async preBuild(t) {
        const ud = t.isVolatile || (await t.dependencyModified());
        if (ud)
            await t.cutoffEarly();
        return ud ? interface_1.PreBuildResult.YES : interface_1.PreBuildResult.NO;
    }
    async shouldTriggerModify(t, itselfModified) {
        return itselfModified;
    }
}
function SelfTracking(dir) {
    return function meta_selfTracking(pattern, FRecipe) {
        const prefix = "Meta::SelfTracking::";
        const matcher = new matchers_1.KindMatcherT(prefix, new matchers_1.ExactMatcher(pattern));
        const rule = new SelfTrackingRule(matcher, FRecipe);
        dir.addRule(rule);
        return (0, util_1.GoalBuilder)(matcher, rule);
    };
}
