//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armauthorization

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GlobalAdministratorClientElevateAccessOptions contains the optional parameters for the GlobalAdministratorClient.ElevateAccess
// method.
type GlobalAdministratorClientElevateAccessOptions struct {
	// placeholder for future optional parameters
}

// Permission - Role definition permissions.
type Permission struct {
	// Allowed actions.
	Actions []*string `json:"actions,omitempty"`

	// Denied actions.
	NotActions []*string `json:"notActions,omitempty"`
}

// PermissionGetResult - Permissions information.
type PermissionGetResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of permissions.
	Value []*Permission `json:"value,omitempty"`
}

// PermissionsClientListForResourceGroupOptions contains the optional parameters for the PermissionsClient.NewListForResourceGroupPager
// method.
type PermissionsClientListForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PermissionsClientListForResourceOptions contains the optional parameters for the PermissionsClient.NewListForResourcePager
// method.
type PermissionsClientListForResourceOptions struct {
	// placeholder for future optional parameters
}

// ProviderOperation - Operation
type ProviderOperation struct {
	// The operation description.
	Description *string `json:"description,omitempty"`

	// The operation display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The operation name.
	Name *string `json:"name,omitempty"`

	// The operation origin.
	Origin *string `json:"origin,omitempty"`

	// The operation properties.
	Properties any `json:"properties,omitempty"`
}

// ProviderOperationsMetadata - Provider Operations metadata
type ProviderOperationsMetadata struct {
	// The provider display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The provider id.
	ID *string `json:"id,omitempty"`

	// The provider name.
	Name *string `json:"name,omitempty"`

	// The provider operations.
	Operations []*ProviderOperation `json:"operations,omitempty"`

	// The provider resource types
	ResourceTypes []*ResourceType `json:"resourceTypes,omitempty"`

	// The provider type.
	Type *string `json:"type,omitempty"`
}

// ProviderOperationsMetadataClientGetOptions contains the optional parameters for the ProviderOperationsMetadataClient.Get
// method.
type ProviderOperationsMetadataClientGetOptions struct {
	// Specifies whether to expand the values.
	Expand *string
}

// ProviderOperationsMetadataClientListOptions contains the optional parameters for the ProviderOperationsMetadataClient.NewListPager
// method.
type ProviderOperationsMetadataClientListOptions struct {
	// Specifies whether to expand the values.
	Expand *string
}

// ProviderOperationsMetadataListResult - Provider operations metadata list
type ProviderOperationsMetadataListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of providers.
	Value []*ProviderOperationsMetadata `json:"value,omitempty"`
}

// ResourceType - Resource Type
type ResourceType struct {
	// The resource type display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The resource type name.
	Name *string `json:"name,omitempty"`

	// The resource type operations.
	Operations []*ProviderOperation `json:"operations,omitempty"`
}

// RoleAssignment - Role Assignments
type RoleAssignment struct {
	// Role assignment properties.
	Properties *RoleAssignmentPropertiesWithScope `json:"properties,omitempty"`

	// READ-ONLY; The role assignment ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The role assignment name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The role assignment type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleAssignmentCreateParameters - Role assignment create parameters.
type RoleAssignmentCreateParameters struct {
	// REQUIRED; Role assignment properties.
	Properties *RoleAssignmentProperties `json:"properties,omitempty"`
}

// RoleAssignmentFilter - Role Assignments filter
type RoleAssignmentFilter struct {
	// Returns role assignment of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
}

// RoleAssignmentListResult - Role assignment list operation result.
type RoleAssignmentListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Role assignment list.
	Value []*RoleAssignment `json:"value,omitempty"`
}

// RoleAssignmentProperties - Role assignment properties.
type RoleAssignmentProperties struct {
	// REQUIRED; The principal ID assigned to the role. This maps to the ID inside the Active Directory. It can point to a user,
	// service principal, or security group.
	PrincipalID *string `json:"principalId,omitempty"`

	// REQUIRED; The role definition ID used in the role assignment.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// RoleAssignmentPropertiesWithScope - Role assignment properties with scope.
type RoleAssignmentPropertiesWithScope struct {
	// The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`

	// The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`

	// The role assignment scope.
	Scope *string `json:"scope,omitempty"`
}

// RoleAssignmentsClientCreateByIDOptions contains the optional parameters for the RoleAssignmentsClient.CreateByID method.
type RoleAssignmentsClientCreateByIDOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientCreateOptions contains the optional parameters for the RoleAssignmentsClient.Create method.
type RoleAssignmentsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientDeleteByIDOptions contains the optional parameters for the RoleAssignmentsClient.DeleteByID method.
type RoleAssignmentsClientDeleteByIDOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientDeleteOptions contains the optional parameters for the RoleAssignmentsClient.Delete method.
type RoleAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetByIDOptions contains the optional parameters for the RoleAssignmentsClient.GetByID method.
type RoleAssignmentsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientGetOptions contains the optional parameters for the RoleAssignmentsClient.Get method.
type RoleAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoleAssignmentsClientListForResourceGroupOptions contains the optional parameters for the RoleAssignmentsClient.NewListForResourceGroupPager
// method.
type RoleAssignmentsClientListForResourceGroupOptions struct {
	// The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId
	// eq {id} to return all role assignments at, above or below the
	// scope for the specified principal.
	Filter *string
}

// RoleAssignmentsClientListForResourceOptions contains the optional parameters for the RoleAssignmentsClient.NewListForResourcePager
// method.
type RoleAssignmentsClientListForResourceOptions struct {
	// The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId
	// eq {id} to return all role assignments at, above or below the
	// scope for the specified principal.
	Filter *string
}

// RoleAssignmentsClientListForScopeOptions contains the optional parameters for the RoleAssignmentsClient.NewListForScopePager
// method.
type RoleAssignmentsClientListForScopeOptions struct {
	// The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId
	// eq {id} to return all role assignments at, above or below the
	// scope for the specified principal.
	Filter *string
}

// RoleAssignmentsClientListOptions contains the optional parameters for the RoleAssignmentsClient.NewListPager method.
type RoleAssignmentsClientListOptions struct {
	// The filter to apply on the operation. Use $filter=atScope() to return all role assignments at or above the scope. Use $filter=principalId
	// eq {id} to return all role assignments at, above or below the
	// scope for the specified principal.
	Filter *string
}

// RoleDefinition - Role definition.
type RoleDefinition struct {
	// Role definition properties.
	Properties *RoleDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The role definition ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The role definition name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The role definition type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RoleDefinitionFilter - Role Definitions filter
type RoleDefinitionFilter struct {
	// Returns role definition with the specific name.
	RoleName *string `json:"roleName,omitempty"`
}

// RoleDefinitionListResult - Role definition list operation result.
type RoleDefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Role definition list.
	Value []*RoleDefinition `json:"value,omitempty"`
}

// RoleDefinitionProperties - Role definition properties.
type RoleDefinitionProperties struct {
	// Role definition assignable scopes.
	AssignableScopes []*string `json:"assignableScopes,omitempty"`

	// The role definition description.
	Description *string `json:"description,omitempty"`

	// Role definition permissions.
	Permissions []*Permission `json:"permissions,omitempty"`

	// The role name.
	RoleName *string `json:"roleName,omitempty"`

	// The role type.
	RoleType *string `json:"type,omitempty"`
}

// RoleDefinitionsClientCreateOrUpdateOptions contains the optional parameters for the RoleDefinitionsClient.CreateOrUpdate
// method.
type RoleDefinitionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientDeleteOptions contains the optional parameters for the RoleDefinitionsClient.Delete method.
type RoleDefinitionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientGetByIDOptions contains the optional parameters for the RoleDefinitionsClient.GetByID method.
type RoleDefinitionsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientGetOptions contains the optional parameters for the RoleDefinitionsClient.Get method.
type RoleDefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoleDefinitionsClientListOptions contains the optional parameters for the RoleDefinitionsClient.NewListPager method.
type RoleDefinitionsClientListOptions struct {
	// The filter to apply on the operation. Use atScopeAndBelow filter to search below the given scope as well.
	Filter *string
}
