//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// SoftwareUpdateConfigurationMachineRunsServer is a fake server for instances of the armautomation.SoftwareUpdateConfigurationMachineRunsClient type.
type SoftwareUpdateConfigurationMachineRunsServer struct {
	// GetByID is the fake for method SoftwareUpdateConfigurationMachineRunsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, resourceGroupName string, automationAccountName string, softwareUpdateConfigurationMachineRunID string, options *armautomation.SoftwareUpdateConfigurationMachineRunsClientGetByIDOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationMachineRunsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SoftwareUpdateConfigurationMachineRunsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, automationAccountName string, options *armautomation.SoftwareUpdateConfigurationMachineRunsClientListOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationMachineRunsClientListResponse], errResp azfake.ErrorResponder)
}

// NewSoftwareUpdateConfigurationMachineRunsServerTransport creates a new instance of SoftwareUpdateConfigurationMachineRunsServerTransport with the provided implementation.
// The returned SoftwareUpdateConfigurationMachineRunsServerTransport instance is connected to an instance of armautomation.SoftwareUpdateConfigurationMachineRunsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSoftwareUpdateConfigurationMachineRunsServerTransport(srv *SoftwareUpdateConfigurationMachineRunsServer) *SoftwareUpdateConfigurationMachineRunsServerTransport {
	return &SoftwareUpdateConfigurationMachineRunsServerTransport{srv: srv}
}

// SoftwareUpdateConfigurationMachineRunsServerTransport connects instances of armautomation.SoftwareUpdateConfigurationMachineRunsClient to instances of SoftwareUpdateConfigurationMachineRunsServer.
// Don't use this type directly, use NewSoftwareUpdateConfigurationMachineRunsServerTransport instead.
type SoftwareUpdateConfigurationMachineRunsServerTransport struct {
	srv *SoftwareUpdateConfigurationMachineRunsServer
}

// Do implements the policy.Transporter interface for SoftwareUpdateConfigurationMachineRunsServerTransport.
func (s *SoftwareUpdateConfigurationMachineRunsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SoftwareUpdateConfigurationMachineRunsClient.GetByID":
		resp, err = s.dispatchGetByID(req)
	case "SoftwareUpdateConfigurationMachineRunsClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SoftwareUpdateConfigurationMachineRunsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if s.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurationMachineRuns/(?P<softwareUpdateConfigurationMachineRunId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	softwareUpdateConfigurationMachineRunIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareUpdateConfigurationMachineRunId")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	var options *armautomation.SoftwareUpdateConfigurationMachineRunsClientGetByIDOptions
	if clientRequestIDParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationMachineRunsClientGetByIDOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := s.srv.GetByID(req.Context(), resourceGroupNameParam, automationAccountNameParam, softwareUpdateConfigurationMachineRunIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfigurationMachineRun, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareUpdateConfigurationMachineRunsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurationMachineRuns`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam := getOptional(topUnescaped)
	var options *armautomation.SoftwareUpdateConfigurationMachineRunsClientListOptions
	if clientRequestIDParam != nil || filterParam != nil || skipParam != nil || topParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationMachineRunsClientListOptions{
			ClientRequestID: clientRequestIDParam,
			Filter:          filterParam,
			Skip:            skipParam,
			Top:             topParam,
		}
	}
	respr, errRespr := s.srv.List(req.Context(), resourceGroupNameParam, automationAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfigurationMachineRunListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
