//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/desktopvirtualization/armdesktopvirtualization/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// DesktopsServer is a fake server for instances of the armdesktopvirtualization.DesktopsClient type.
type DesktopsServer struct {
	// Get is the fake for method DesktopsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, applicationGroupName string, desktopName string, options *armdesktopvirtualization.DesktopsClientGetOptions) (resp azfake.Responder[armdesktopvirtualization.DesktopsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DesktopsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, applicationGroupName string, options *armdesktopvirtualization.DesktopsClientListOptions) (resp azfake.PagerResponder[armdesktopvirtualization.DesktopsClientListResponse])

	// Update is the fake for method DesktopsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, applicationGroupName string, desktopName string, options *armdesktopvirtualization.DesktopsClientUpdateOptions) (resp azfake.Responder[armdesktopvirtualization.DesktopsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDesktopsServerTransport creates a new instance of DesktopsServerTransport with the provided implementation.
// The returned DesktopsServerTransport instance is connected to an instance of armdesktopvirtualization.DesktopsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDesktopsServerTransport(srv *DesktopsServer) *DesktopsServerTransport {
	return &DesktopsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdesktopvirtualization.DesktopsClientListResponse]](),
	}
}

// DesktopsServerTransport connects instances of armdesktopvirtualization.DesktopsClient to instances of DesktopsServer.
// Don't use this type directly, use NewDesktopsServerTransport instead.
type DesktopsServerTransport struct {
	srv          *DesktopsServer
	newListPager *tracker[azfake.PagerResponder[armdesktopvirtualization.DesktopsClientListResponse]]
}

// Do implements the policy.Transporter interface for DesktopsServerTransport.
func (d *DesktopsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DesktopsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DesktopsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DesktopsClient.Update":
		resp, err = d.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DesktopsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/applicationGroups/(?P<applicationGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/desktops/(?P<desktopName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationGroupName")])
	if err != nil {
		return nil, err
	}
	desktopNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("desktopName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, applicationGroupNameParam, desktopNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Desktop, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DesktopsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/applicationGroups/(?P<applicationGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/desktops`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		applicationGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationGroupName")])
		if err != nil {
			return nil, err
		}
		pageSizeUnescaped, err := url.QueryUnescape(qp.Get("pageSize"))
		if err != nil {
			return nil, err
		}
		pageSizeParam, err := parseOptional(pageSizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		isDescendingUnescaped, err := url.QueryUnescape(qp.Get("isDescending"))
		if err != nil {
			return nil, err
		}
		isDescendingParam, err := parseOptional(isDescendingUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		initialSkipUnescaped, err := url.QueryUnescape(qp.Get("initialSkip"))
		if err != nil {
			return nil, err
		}
		initialSkipParam, err := parseOptional(initialSkipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdesktopvirtualization.DesktopsClientListOptions
		if pageSizeParam != nil || isDescendingParam != nil || initialSkipParam != nil {
			options = &armdesktopvirtualization.DesktopsClientListOptions{
				PageSize:     pageSizeParam,
				IsDescending: isDescendingParam,
				InitialSkip:  initialSkipParam,
			}
		}
		resp := d.srv.NewListPager(resourceGroupNameParam, applicationGroupNameParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdesktopvirtualization.DesktopsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DesktopsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/applicationGroups/(?P<applicationGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/desktops/(?P<desktopName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.DesktopPatch](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	applicationGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationGroupName")])
	if err != nil {
		return nil, err
	}
	desktopNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("desktopName")])
	if err != nil {
		return nil, err
	}
	var options *armdesktopvirtualization.DesktopsClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdesktopvirtualization.DesktopsClientUpdateOptions{
			Desktop: &body,
		}
	}
	respr, errRespr := d.srv.Update(req.Context(), resourceGroupNameParam, applicationGroupNameParam, desktopNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Desktop, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
