//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhanaonazure

// Display - Detailed HANA operation information
type Display struct {
	// READ-ONLY; The localized friendly description for the operation as shown to the user. This description should be thorough,
	// yet concise. It will be used in tool-tips and detailed views.
	Description *string

	// READ-ONLY; The localized friendly name for the operation as shown to the user. This name should be concise (to fit in drop
	// downs), but clear (self-documenting). Use Title Casing and include the entity/resource
	// to which it applies.
	Operation *string

	// READ-ONLY; The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs
	// UX. Default value is 'user,system'
	Origin *string

	// READ-ONLY; The localized friendly form of the resource provider name. This form is also expected to include the publisher/company
	// responsible. Use Title Casing. Begin with "Microsoft" for 1st party services.
	Provider *string

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation. This form should match the
	// public documentation for the resource provider. Use Title Casing. For examples, refer to
	// the “name” section.
	Resource *string
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Describes the error object.
	Error *ErrorResponseError
}

// ErrorResponseError - Describes the error object.
type ErrorResponseError struct {
	// READ-ONLY; Error code
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// Operation - HANA operation information
type Operation struct {
	// Displayed HANA operation information
	Display *Display

	// READ-ONLY; The name of the operation being performed on this particular object. This name should match the action name
	// that appears in RBAC / the event service.
	Name *string
}

// OperationList - List of HANA operations
type OperationList struct {
	// List of HANA operations
	Value []*Operation
}

// ProviderInstance - A provider instance associated with a SAP monitor.
type ProviderInstance struct {
	// Provider Instance properties
	Properties *ProviderInstanceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProviderInstanceListResult - The response from the List provider instances operation.
type ProviderInstanceListResult struct {
	// The URL to get the next set of provider instances.
	NextLink *string

	// The list of provider instances.
	Value []*ProviderInstance
}

// ProviderInstanceProperties - Describes the properties of a provider instance.
type ProviderInstanceProperties struct {
	// A JSON string containing metadata of the provider instance.
	Metadata *string

	// A JSON string containing the properties of the provider instance.
	Properties *string

	// The type of provider instance.
	Type *string

	// READ-ONLY; State of provisioning of the provider instance
	ProvisioningState *HanaProvisioningStatesEnum
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SapMonitor - SAP monitor info on Azure (ARM properties and SAP monitor properties)
type SapMonitor struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// SAP monitor properties
	Properties *SapMonitorProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SapMonitorListResult - The response from the List SAP monitors operation.
type SapMonitorListResult struct {
	// The URL to get the next set of SAP monitors.
	NextLink *string

	// The list of SAP monitors.
	Value []*SapMonitor
}

// SapMonitorProperties - Describes the properties of a SAP monitor.
type SapMonitorProperties struct {
	// The value indicating whether to send analytics to Microsoft
	EnableCustomerAnalytics *bool

	// The ARM ID of the Log Analytics Workspace that is used for monitoring
	LogAnalyticsWorkspaceArmID *string

	// The workspace ID of the log analytics workspace to be used for monitoring
	LogAnalyticsWorkspaceID *string

	// The shared key of the log analytics workspace that is used for monitoring
	LogAnalyticsWorkspaceSharedKey *string

	// The subnet which the SAP monitor will be deployed in
	MonitorSubnet *string

	// READ-ONLY; The name of the resource group the SAP Monitor resources get deployed into.
	ManagedResourceGroupName *string

	// READ-ONLY; State of provisioning of the HanaInstance
	ProvisioningState *HanaProvisioningStatesEnum

	// READ-ONLY; The version of the payload running in the Collector VM
	SapMonitorCollectorVersion *string
}

// Tags field of the resource.
type Tags struct {
	// Tags field of the resource.
	Tags map[string]*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}
