//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkusto_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/azure-kusto/resource-manager/Microsoft.Kusto/stable/2023-08-15/examples/KustoDatabaseInviteFollower.json
func ExampleDatabaseClient_InviteFollower() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkusto.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseClient().InviteFollower(ctx, "kustorptest", "kustoCluster", "database", armkusto.DatabaseInviteFollowerRequest{
		InviteeEmail: to.Ptr("invitee@contoso.com"),
		TableLevelSharingProperties: &armkusto.TableLevelSharingProperties{
			ExternalTablesToExclude: []*string{},
			ExternalTablesToInclude: []*string{
				to.Ptr("ExternalTable*")},
			FunctionsToExclude: []*string{
				to.Ptr("functionsToExclude2")},
			FunctionsToInclude: []*string{
				to.Ptr("functionsToInclude1")},
			MaterializedViewsToExclude: []*string{
				to.Ptr("MaterializedViewTable2")},
			MaterializedViewsToInclude: []*string{
				to.Ptr("MaterializedViewTable1")},
			TablesToExclude: []*string{
				to.Ptr("Table2")},
			TablesToInclude: []*string{
				to.Ptr("Table1")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseInviteFollowerResult = armkusto.DatabaseInviteFollowerResult{
	// 	GeneratedInvitation: to.Ptr("eyJ0eXAiOiJKVInvitationToken"),
	// }
}
