//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	"net/http"
	"net/url"
	"regexp"
)

// NetworkFabricsServer is a fake server for instances of the armmanagednetworkfabric.NetworkFabricsClient type.
type NetworkFabricsServer struct {
	// BeginCommitConfiguration is the fake for method NetworkFabricsClient.BeginCommitConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCommitConfiguration func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginCommitConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCommitConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method NetworkFabricsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.NetworkFabric, options *armmanagednetworkfabric.NetworkFabricsClientBeginCreateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method NetworkFabricsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeprovision is the fake for method NetworkFabricsClient.BeginDeprovision
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeprovision func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginDeprovisionOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeprovisionResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method NetworkFabricsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientGetOptions) (resp azfake.Responder[armmanagednetworkfabric.NetworkFabricsClientGetResponse], errResp azfake.ErrorResponder)

	// BeginGetTopology is the fake for method NetworkFabricsClient.BeginGetTopology
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetTopology func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginGetTopologyOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientGetTopologyResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method NetworkFabricsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmanagednetworkfabric.NetworkFabricsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method NetworkFabricsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagednetworkfabric.NetworkFabricsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListBySubscriptionResponse])

	// BeginProvision is the fake for method NetworkFabricsClient.BeginProvision
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginProvision func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginProvisionOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientProvisionResponse], errResp azfake.ErrorResponder)

	// BeginRefreshConfiguration is the fake for method NetworkFabricsClient.BeginRefreshConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRefreshConfiguration func(ctx context.Context, resourceGroupName string, networkFabricName string, options *armmanagednetworkfabric.NetworkFabricsClientBeginRefreshConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientRefreshConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method NetworkFabricsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.NetworkFabricPatch, options *armmanagednetworkfabric.NetworkFabricsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateInfraManagementBfdConfiguration is the fake for method NetworkFabricsClient.BeginUpdateInfraManagementBfdConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateInfraManagementBfdConfiguration func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.NetworkFabricsClientBeginUpdateInfraManagementBfdConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginUpdateWorkloadManagementBfdConfiguration is the fake for method NetworkFabricsClient.BeginUpdateWorkloadManagementBfdConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateWorkloadManagementBfdConfiguration func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.NetworkFabricsClientBeginUpdateWorkloadManagementBfdConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginUpgrade is the fake for method NetworkFabricsClient.BeginUpgrade
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpgrade func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.UpdateVersion, options *armmanagednetworkfabric.NetworkFabricsClientBeginUpgradeOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpgradeResponse], errResp azfake.ErrorResponder)

	// BeginValidateConfiguration is the fake for method NetworkFabricsClient.BeginValidateConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateConfiguration func(ctx context.Context, resourceGroupName string, networkFabricName string, body armmanagednetworkfabric.ValidateConfigurationProperties, options *armmanagednetworkfabric.NetworkFabricsClientBeginValidateConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientValidateConfigurationResponse], errResp azfake.ErrorResponder)
}

// NewNetworkFabricsServerTransport creates a new instance of NetworkFabricsServerTransport with the provided implementation.
// The returned NetworkFabricsServerTransport instance is connected to an instance of armmanagednetworkfabric.NetworkFabricsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNetworkFabricsServerTransport(srv *NetworkFabricsServer) *NetworkFabricsServerTransport {
	return &NetworkFabricsServerTransport{
		srv:                         srv,
		beginCommitConfiguration:    newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCommitConfigurationResponse]](),
		beginCreate:                 newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeleteResponse]](),
		beginDeprovision:            newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeprovisionResponse]](),
		beginGetTopology:            newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientGetTopologyResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListBySubscriptionResponse]](),
		beginProvision:              newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientProvisionResponse]](),
		beginRefreshConfiguration:   newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientRefreshConfigurationResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateResponse]](),
		beginUpdateInfraManagementBfdConfiguration:    newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse]](),
		beginUpdateWorkloadManagementBfdConfiguration: newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse]](),
		beginUpgrade:               newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpgradeResponse]](),
		beginValidateConfiguration: newTracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientValidateConfigurationResponse]](),
	}
}

// NetworkFabricsServerTransport connects instances of armmanagednetworkfabric.NetworkFabricsClient to instances of NetworkFabricsServer.
// Don't use this type directly, use NewNetworkFabricsServerTransport instead.
type NetworkFabricsServerTransport struct {
	srv                                           *NetworkFabricsServer
	beginCommitConfiguration                      *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCommitConfigurationResponse]]
	beginCreate                                   *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientCreateResponse]]
	beginDelete                                   *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeleteResponse]]
	beginDeprovision                              *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientDeprovisionResponse]]
	beginGetTopology                              *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientGetTopologyResponse]]
	newListByResourceGroupPager                   *tracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListByResourceGroupResponse]]
	newListBySubscriptionPager                    *tracker[azfake.PagerResponder[armmanagednetworkfabric.NetworkFabricsClientListBySubscriptionResponse]]
	beginProvision                                *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientProvisionResponse]]
	beginRefreshConfiguration                     *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientRefreshConfigurationResponse]]
	beginUpdate                                   *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateResponse]]
	beginUpdateInfraManagementBfdConfiguration    *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateInfraManagementBfdConfigurationResponse]]
	beginUpdateWorkloadManagementBfdConfiguration *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpdateWorkloadManagementBfdConfigurationResponse]]
	beginUpgrade                                  *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientUpgradeResponse]]
	beginValidateConfiguration                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.NetworkFabricsClientValidateConfigurationResponse]]
}

// Do implements the policy.Transporter interface for NetworkFabricsServerTransport.
func (n *NetworkFabricsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NetworkFabricsClient.BeginCommitConfiguration":
		resp, err = n.dispatchBeginCommitConfiguration(req)
	case "NetworkFabricsClient.BeginCreate":
		resp, err = n.dispatchBeginCreate(req)
	case "NetworkFabricsClient.BeginDelete":
		resp, err = n.dispatchBeginDelete(req)
	case "NetworkFabricsClient.BeginDeprovision":
		resp, err = n.dispatchBeginDeprovision(req)
	case "NetworkFabricsClient.Get":
		resp, err = n.dispatchGet(req)
	case "NetworkFabricsClient.BeginGetTopology":
		resp, err = n.dispatchBeginGetTopology(req)
	case "NetworkFabricsClient.NewListByResourceGroupPager":
		resp, err = n.dispatchNewListByResourceGroupPager(req)
	case "NetworkFabricsClient.NewListBySubscriptionPager":
		resp, err = n.dispatchNewListBySubscriptionPager(req)
	case "NetworkFabricsClient.BeginProvision":
		resp, err = n.dispatchBeginProvision(req)
	case "NetworkFabricsClient.BeginRefreshConfiguration":
		resp, err = n.dispatchBeginRefreshConfiguration(req)
	case "NetworkFabricsClient.BeginUpdate":
		resp, err = n.dispatchBeginUpdate(req)
	case "NetworkFabricsClient.BeginUpdateInfraManagementBfdConfiguration":
		resp, err = n.dispatchBeginUpdateInfraManagementBfdConfiguration(req)
	case "NetworkFabricsClient.BeginUpdateWorkloadManagementBfdConfiguration":
		resp, err = n.dispatchBeginUpdateWorkloadManagementBfdConfiguration(req)
	case "NetworkFabricsClient.BeginUpgrade":
		resp, err = n.dispatchBeginUpgrade(req)
	case "NetworkFabricsClient.BeginValidateConfiguration":
		resp, err = n.dispatchBeginValidateConfiguration(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginCommitConfiguration(req *http.Request) (*http.Response, error) {
	if n.srv.BeginCommitConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommitConfiguration not implemented")}
	}
	beginCommitConfiguration := n.beginCommitConfiguration.get(req)
	if beginCommitConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginCommitConfiguration(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommitConfiguration = &respr
		n.beginCommitConfiguration.add(req, beginCommitConfiguration)
	}

	resp, err := server.PollerResponderNext(beginCommitConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginCommitConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommitConfiguration) {
		n.beginCommitConfiguration.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if n.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := n.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.NetworkFabric](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginCreate(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		n.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		n.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		n.beginCreate.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if n.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := n.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginDelete(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		n.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		n.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		n.beginDelete.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginDeprovision(req *http.Request) (*http.Response, error) {
	if n.srv.BeginDeprovision == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeprovision not implemented")}
	}
	beginDeprovision := n.beginDeprovision.get(req)
	if beginDeprovision == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deprovision`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginDeprovision(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeprovision = &respr
		n.beginDeprovision.add(req, beginDeprovision)
	}

	resp, err := server.PollerResponderNext(beginDeprovision, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginDeprovision.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeprovision) {
		n.beginDeprovision.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkFabric, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginGetTopology(req *http.Request) (*http.Response, error) {
	if n.srv.BeginGetTopology == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetTopology not implemented")}
	}
	beginGetTopology := n.beginGetTopology.get(req)
	if beginGetTopology == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getTopology`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginGetTopology(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetTopology = &respr
		n.beginGetTopology.add(req, beginGetTopology)
	}

	resp, err := server.PollerResponderNext(beginGetTopology, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginGetTopology.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetTopology) {
		n.beginGetTopology.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := n.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := n.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		n.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmanagednetworkfabric.NetworkFabricsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		n.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := n.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := n.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		n.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagednetworkfabric.NetworkFabricsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		n.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginProvision(req *http.Request) (*http.Response, error) {
	if n.srv.BeginProvision == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginProvision not implemented")}
	}
	beginProvision := n.beginProvision.get(req)
	if beginProvision == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/provision`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginProvision(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginProvision = &respr
		n.beginProvision.add(req, beginProvision)
	}

	resp, err := server.PollerResponderNext(beginProvision, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginProvision.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginProvision) {
		n.beginProvision.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginRefreshConfiguration(req *http.Request) (*http.Response, error) {
	if n.srv.BeginRefreshConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefreshConfiguration not implemented")}
	}
	beginRefreshConfiguration := n.beginRefreshConfiguration.get(req)
	if beginRefreshConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginRefreshConfiguration(req.Context(), resourceGroupNameParam, networkFabricNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefreshConfiguration = &respr
		n.beginRefreshConfiguration.add(req, beginRefreshConfiguration)
	}

	resp, err := server.PollerResponderNext(beginRefreshConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginRefreshConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefreshConfiguration) {
		n.beginRefreshConfiguration.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if n.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := n.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.NetworkFabricPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginUpdate(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		n.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		n.beginUpdate.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginUpdateInfraManagementBfdConfiguration(req *http.Request) (*http.Response, error) {
	if n.srv.BeginUpdateInfraManagementBfdConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateInfraManagementBfdConfiguration not implemented")}
	}
	beginUpdateInfraManagementBfdConfiguration := n.beginUpdateInfraManagementBfdConfiguration.get(req)
	if beginUpdateInfraManagementBfdConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateInfraManagementBfdConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginUpdateInfraManagementBfdConfiguration(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateInfraManagementBfdConfiguration = &respr
		n.beginUpdateInfraManagementBfdConfiguration.add(req, beginUpdateInfraManagementBfdConfiguration)
	}

	resp, err := server.PollerResponderNext(beginUpdateInfraManagementBfdConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginUpdateInfraManagementBfdConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateInfraManagementBfdConfiguration) {
		n.beginUpdateInfraManagementBfdConfiguration.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginUpdateWorkloadManagementBfdConfiguration(req *http.Request) (*http.Response, error) {
	if n.srv.BeginUpdateWorkloadManagementBfdConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateWorkloadManagementBfdConfiguration not implemented")}
	}
	beginUpdateWorkloadManagementBfdConfiguration := n.beginUpdateWorkloadManagementBfdConfiguration.get(req)
	if beginUpdateWorkloadManagementBfdConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateWorkloadManagementBfdConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginUpdateWorkloadManagementBfdConfiguration(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateWorkloadManagementBfdConfiguration = &respr
		n.beginUpdateWorkloadManagementBfdConfiguration.add(req, beginUpdateWorkloadManagementBfdConfiguration)
	}

	resp, err := server.PollerResponderNext(beginUpdateWorkloadManagementBfdConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginUpdateWorkloadManagementBfdConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateWorkloadManagementBfdConfiguration) {
		n.beginUpdateWorkloadManagementBfdConfiguration.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginUpgrade(req *http.Request) (*http.Response, error) {
	if n.srv.BeginUpgrade == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgrade not implemented")}
	}
	beginUpgrade := n.beginUpgrade.get(req)
	if beginUpgrade == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateVersion](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginUpgrade(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgrade = &respr
		n.beginUpgrade.add(req, beginUpgrade)
	}

	resp, err := server.PollerResponderNext(beginUpgrade, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginUpgrade.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgrade) {
		n.beginUpgrade.remove(req)
	}

	return resp, nil
}

func (n *NetworkFabricsServerTransport) dispatchBeginValidateConfiguration(req *http.Request) (*http.Response, error) {
	if n.srv.BeginValidateConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateConfiguration not implemented")}
	}
	beginValidateConfiguration := n.beginValidateConfiguration.get(req)
	if beginValidateConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/networkFabrics/(?P<networkFabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.ValidateConfigurationProperties](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		networkFabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFabricName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginValidateConfiguration(req.Context(), resourceGroupNameParam, networkFabricNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateConfiguration = &respr
		n.beginValidateConfiguration.add(req, beginValidateConfiguration)
	}

	resp, err := server.PollerResponderNext(beginValidateConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginValidateConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateConfiguration) {
		n.beginValidateConfiguration.remove(req)
	}

	return resp, nil
}
