//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/SavedSearchesGetSchema.json
func ExampleSchemaClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSchemaClient().Get(ctx, "mms-eus", "atlantisdemo", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SearchGetSchemaResponse = armoperationalinsights.SearchGetSchemaResponse{
	// 	Metadata: &armoperationalinsights.SearchMetadata{
	// 		Schema: &armoperationalinsights.SearchMetadataSchema{
	// 			Name: to.Ptr("CloudOps"),
	// 			Version: to.Ptr[int32](2),
	// 		},
	// 		RequestTime: to.Ptr[int64](28),
	// 		ResultType: to.Ptr("schema"),
	// 	},
	// 	Value: []*armoperationalinsights.SearchSchemaValue{
	// 		{
	// 			Name: to.Ptr("TenantId"),
	// 			Type: to.Ptr("Guid"),
	// 			DisplayName: to.Ptr("TenantId"),
	// 			Facet: to.Ptr(false),
	// 			Indexed: to.Ptr(true),
	// 			OwnerType: []*string{
	// 				to.Ptr("Alert"),
	// 				to.Ptr("AzureActivity"),
	// 				to.Ptr("AzureAudit"),
	// 				to.Ptr("AzureMetrics"),
	// 				to.Ptr("ComputerGroup"),
	// 				to.Ptr("ETWEvent"),
	// 				to.Ptr("Event"),
	// 				to.Ptr("ExtraHopDBLogin"),
	// 				to.Ptr("ExtraHopDBTransaction"),
	// 				to.Ptr("ExtraHopDNSResponse"),
	// 				to.Ptr("ExtraHopFTPResponse"),
	// 				to.Ptr("ExtraHopHTTPTransaction"),
	// 				to.Ptr("ExtraHopSMTPMessage"),
	// 				to.Ptr("ExtraHopSYNScanDetect"),
	// 				to.Ptr("ExtraHopTCPOpen"),
	// 				to.Ptr("Heartbeat"),
	// 				to.Ptr("Operation"),
	// 				to.Ptr("Perf"),
	// 				to.Ptr("ReservedAzureCommonFields"),
	// 				to.Ptr("ReservedCommonFields"),
	// 				to.Ptr("ServiceFabricOperationalEvent"),
	// 				to.Ptr("ServiceFabricReliableActorEvent"),
	// 				to.Ptr("ServiceFabricReliableServiceEvent"),
	// 				to.Ptr("Syslog"),
	// 				to.Ptr("Usage"),
	// 				to.Ptr("W3CIISLog")},
	// 				Stored: to.Ptr(false),
	// 		}},
	// 	}
}
