//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
	"time"
)

// PolicyEventsServer is a fake server for instances of the armpolicyinsights.PolicyEventsClient type.
type PolicyEventsServer struct {
	// NewListQueryResultsForManagementGroupPager is the fake for method PolicyEventsClient.NewListQueryResultsForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForManagementGroupPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, managementGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForManagementGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForManagementGroupResponse])

	// NewListQueryResultsForPolicyDefinitionPager is the fake for method PolicyEventsClient.NewListQueryResultsForPolicyDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForPolicyDefinitionPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, policyDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForPolicyDefinitionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicyDefinitionResponse])

	// NewListQueryResultsForPolicySetDefinitionPager is the fake for method PolicyEventsClient.NewListQueryResultsForPolicySetDefinitionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForPolicySetDefinitionPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, policySetDefinitionName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse])

	// NewListQueryResultsForResourcePager is the fake for method PolicyEventsClient.NewListQueryResultsForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourcePager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, resourceID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceResponse])

	// NewListQueryResultsForResourceGroupPager is the fake for method PolicyEventsClient.NewListQueryResultsForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourceGroupPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, resourceGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupResponse])

	// NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager is the fake for method PolicyEventsClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, resourceGroupName string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse])

	// NewListQueryResultsForSubscriptionPager is the fake for method PolicyEventsClient.NewListQueryResultsForSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForSubscriptionPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionResponse])

	// NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager is the fake for method PolicyEventsClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager func(policyEventsResource armpolicyinsights.PolicyEventsResourceType, subscriptionID string, policyAssignmentName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse])
}

// NewPolicyEventsServerTransport creates a new instance of PolicyEventsServerTransport with the provided implementation.
// The returned PolicyEventsServerTransport instance is connected to an instance of armpolicyinsights.PolicyEventsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyEventsServerTransport(srv *PolicyEventsServer) *PolicyEventsServerTransport {
	return &PolicyEventsServerTransport{
		srv: srv,
		newListQueryResultsForManagementGroupPager:                    newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForManagementGroupResponse]](),
		newListQueryResultsForPolicyDefinitionPager:                   newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicyDefinitionResponse]](),
		newListQueryResultsForPolicySetDefinitionPager:                newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse]](),
		newListQueryResultsForResourcePager:                           newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceResponse]](),
		newListQueryResultsForResourceGroupPager:                      newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupResponse]](),
		newListQueryResultsForResourceGroupLevelPolicyAssignmentPager: newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]](),
		newListQueryResultsForSubscriptionPager:                       newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionResponse]](),
		newListQueryResultsForSubscriptionLevelPolicyAssignmentPager:  newTracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]](),
	}
}

// PolicyEventsServerTransport connects instances of armpolicyinsights.PolicyEventsClient to instances of PolicyEventsServer.
// Don't use this type directly, use NewPolicyEventsServerTransport instead.
type PolicyEventsServerTransport struct {
	srv                                                           *PolicyEventsServer
	newListQueryResultsForManagementGroupPager                    *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForManagementGroupResponse]]
	newListQueryResultsForPolicyDefinitionPager                   *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicyDefinitionResponse]]
	newListQueryResultsForPolicySetDefinitionPager                *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse]]
	newListQueryResultsForResourcePager                           *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceResponse]]
	newListQueryResultsForResourceGroupPager                      *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupResponse]]
	newListQueryResultsForResourceGroupLevelPolicyAssignmentPager *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse]]
	newListQueryResultsForSubscriptionPager                       *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionResponse]]
	newListQueryResultsForSubscriptionLevelPolicyAssignmentPager  *tracker[azfake.PagerResponder[armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse]]
}

// Do implements the policy.Transporter interface for PolicyEventsServerTransport.
func (p *PolicyEventsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyEventsClient.NewListQueryResultsForManagementGroupPager":
		resp, err = p.dispatchNewListQueryResultsForManagementGroupPager(req)
	case "PolicyEventsClient.NewListQueryResultsForPolicyDefinitionPager":
		resp, err = p.dispatchNewListQueryResultsForPolicyDefinitionPager(req)
	case "PolicyEventsClient.NewListQueryResultsForPolicySetDefinitionPager":
		resp, err = p.dispatchNewListQueryResultsForPolicySetDefinitionPager(req)
	case "PolicyEventsClient.NewListQueryResultsForResourcePager":
		resp, err = p.dispatchNewListQueryResultsForResourcePager(req)
	case "PolicyEventsClient.NewListQueryResultsForResourceGroupPager":
		resp, err = p.dispatchNewListQueryResultsForResourceGroupPager(req)
	case "PolicyEventsClient.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager":
		resp, err = p.dispatchNewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(req)
	case "PolicyEventsClient.NewListQueryResultsForSubscriptionPager":
		resp, err = p.dispatchNewListQueryResultsForSubscriptionPager(req)
	case "PolicyEventsClient.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager":
		resp, err = p.dispatchNewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForManagementGroupPager not implemented")}
	}
	newListQueryResultsForManagementGroupPager := p.newListQueryResultsForManagementGroupPager.get(req)
	if newListQueryResultsForManagementGroupPager == nil {
		const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForManagementGroupPager(policyEventsResourceParam, managementGroupNameParam, queryOptions, nil)
		newListQueryResultsForManagementGroupPager = &resp
		p.newListQueryResultsForManagementGroupPager.add(req, newListQueryResultsForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForManagementGroupPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForManagementGroupResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForManagementGroupPager) {
		p.newListQueryResultsForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForPolicyDefinitionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForPolicyDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForPolicyDefinitionPager not implemented")}
	}
	newListQueryResultsForPolicyDefinitionPager := p.newListQueryResultsForPolicyDefinitionPager.get(req)
	if newListQueryResultsForPolicyDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyDefinitions/(?P<policyDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policyDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyDefinitionName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForPolicyDefinitionPager(policyEventsResourceParam, subscriptionIDParam, policyDefinitionNameParam, queryOptions, nil)
		newListQueryResultsForPolicyDefinitionPager = &resp
		p.newListQueryResultsForPolicyDefinitionPager.add(req, newListQueryResultsForPolicyDefinitionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForPolicyDefinitionPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForPolicyDefinitionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForPolicyDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForPolicyDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForPolicyDefinitionPager) {
		p.newListQueryResultsForPolicyDefinitionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForPolicySetDefinitionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForPolicySetDefinitionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForPolicySetDefinitionPager not implemented")}
	}
	newListQueryResultsForPolicySetDefinitionPager := p.newListQueryResultsForPolicySetDefinitionPager.get(req)
	if newListQueryResultsForPolicySetDefinitionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policySetDefinitions/(?P<policySetDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policySetDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policySetDefinitionName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForPolicySetDefinitionPager(policyEventsResourceParam, subscriptionIDParam, policySetDefinitionNameParam, queryOptions, nil)
		newListQueryResultsForPolicySetDefinitionPager = &resp
		p.newListQueryResultsForPolicySetDefinitionPager.add(req, newListQueryResultsForPolicySetDefinitionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForPolicySetDefinitionPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForPolicySetDefinitionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForPolicySetDefinitionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForPolicySetDefinitionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForPolicySetDefinitionPager) {
		p.newListQueryResultsForPolicySetDefinitionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForResourcePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourcePager not implemented")}
	}
	newListQueryResultsForResourcePager := p.newListQueryResultsForResourcePager.get(req)
	if newListQueryResultsForResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || expandParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				Expand:    expandParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourcePager(policyEventsResourceParam, resourceIDParam, queryOptions, nil)
		newListQueryResultsForResourcePager = &resp
		p.newListQueryResultsForResourcePager.add(req, newListQueryResultsForResourcePager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourcePager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourcePager) {
		p.newListQueryResultsForResourcePager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourceGroupPager not implemented")}
	}
	newListQueryResultsForResourceGroupPager := p.newListQueryResultsForResourceGroupPager.get(req)
	if newListQueryResultsForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourceGroupPager(policyEventsResourceParam, subscriptionIDParam, resourceGroupNameParam, queryOptions, nil)
		newListQueryResultsForResourceGroupPager = &resp
		p.newListQueryResultsForResourceGroupPager.add(req, newListQueryResultsForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourceGroupPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourceGroupPager) {
		p.newListQueryResultsForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager not implemented")}
	}
	newListQueryResultsForResourceGroupLevelPolicyAssignmentPager := p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.get(req)
	if newListQueryResultsForResourceGroupLevelPolicyAssignmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForResourceGroupLevelPolicyAssignmentPager(policyEventsResourceParam, subscriptionIDParam, resourceGroupNameParam, policyAssignmentNameParam, queryOptions, nil)
		newListQueryResultsForResourceGroupLevelPolicyAssignmentPager = &resp
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.add(req, newListQueryResultsForResourceGroupLevelPolicyAssignmentPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForResourceGroupLevelPolicyAssignmentPager) {
		p.newListQueryResultsForResourceGroupLevelPolicyAssignmentPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForSubscriptionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForSubscriptionPager not implemented")}
	}
	newListQueryResultsForSubscriptionPager := p.newListQueryResultsForSubscriptionPager.get(req)
	if newListQueryResultsForSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForSubscriptionPager(policyEventsResourceParam, subscriptionIDParam, queryOptions, nil)
		newListQueryResultsForSubscriptionPager = &resp
		p.newListQueryResultsForSubscriptionPager.add(req, newListQueryResultsForSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForSubscriptionPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForSubscriptionPager) {
		p.newListQueryResultsForSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (p *PolicyEventsServerTransport) dispatchNewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager not implemented")}
	}
	newListQueryResultsForSubscriptionLevelPolicyAssignmentPager := p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.get(req)
	if newListQueryResultsForSubscriptionLevelPolicyAssignmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<authorizationNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/policyEvents/(?P<policyEventsResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryResults`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		policyEventsResourceParam, err := parseWithCast(matches[regex.SubexpIndex("policyEventsResource")], func(v string) (armpolicyinsights.PolicyEventsResourceType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armpolicyinsights.PolicyEventsResourceType(p), nil
		})
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderByUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderByParam := getOptional(orderByUnescaped)
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		fromUnescaped, err := url.QueryUnescape(qp.Get("$from"))
		if err != nil {
			return nil, err
		}
		fromParam, err := parseOptional(fromUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		toUnescaped, err := url.QueryUnescape(qp.Get("$to"))
		if err != nil {
			return nil, err
		}
		toParam, err := parseOptional(toUnescaped, func(v string) (time.Time, error) { return time.Parse(time.RFC3339Nano, v) })
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		applyUnescaped, err := url.QueryUnescape(qp.Get("$apply"))
		if err != nil {
			return nil, err
		}
		applyParam := getOptional(applyUnescaped)
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || orderByParam != nil || selectParam != nil || fromParam != nil || toParam != nil || filterParam != nil || applyParam != nil || skipTokenParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:       topParam,
				OrderBy:   orderByParam,
				Select:    selectParam,
				From:      fromParam,
				To:        toParam,
				Filter:    filterParam,
				Apply:     applyParam,
				SkipToken: skipTokenParam,
			}
		}
		resp := p.srv.NewListQueryResultsForSubscriptionLevelPolicyAssignmentPager(policyEventsResourceParam, subscriptionIDParam, policyAssignmentNameParam, queryOptions, nil)
		newListQueryResultsForSubscriptionLevelPolicyAssignmentPager = &resp
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.add(req, newListQueryResultsForSubscriptionLevelPolicyAssignmentPager)
		server.PagerResponderInjectNextLinks(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager, req, func(page *armpolicyinsights.PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListQueryResultsForSubscriptionLevelPolicyAssignmentPager) {
		p.newListQueryResultsForSubscriptionLevelPolicyAssignmentPager.remove(req)
	}
	return resp, nil
}
