//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationProtectedItemsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationProtectedItemsClient type.
type ReplicationProtectedItemsServer struct {
	// BeginAddDisks is the fake for method ReplicationProtectedItemsClient.BeginAddDisks
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAddDisks func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, addDisksInput armrecoveryservicessiterecovery.AddDisksInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginAddDisksOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientAddDisksResponse], errResp azfake.ErrorResponder)

	// BeginApplyRecoveryPoint is the fake for method ReplicationProtectedItemsClient.BeginApplyRecoveryPoint
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginApplyRecoveryPoint func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, applyRecoveryPointInput armrecoveryservicessiterecovery.ApplyRecoveryPointInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginApplyRecoveryPointOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientApplyRecoveryPointResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method ReplicationProtectedItemsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, input armrecoveryservicessiterecovery.EnableProtectionInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginCreateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ReplicationProtectedItemsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, disableProtectionInput armrecoveryservicessiterecovery.DisableProtectionInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginDeleteOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailoverCancel is the fake for method ReplicationProtectedItemsClient.BeginFailoverCancel
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFailoverCancel func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginFailoverCancelOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCancelResponse], errResp azfake.ErrorResponder)

	// BeginFailoverCommit is the fake for method ReplicationProtectedItemsClient.BeginFailoverCommit
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFailoverCommit func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginFailoverCommitOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCommitResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationProtectedItemsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationProtectedItemsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListResponse])

	// NewListByReplicationProtectionContainersPager is the fake for method ReplicationProtectedItemsClient.NewListByReplicationProtectionContainersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationProtectionContainersPager func(resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListByReplicationProtectionContainersOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListByReplicationProtectionContainersResponse])

	// BeginPlannedFailover is the fake for method ReplicationProtectedItemsClient.BeginPlannedFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPlannedFailover func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput armrecoveryservicessiterecovery.PlannedFailoverInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginPlannedFailoverOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPlannedFailoverResponse], errResp azfake.ErrorResponder)

	// BeginPurge is the fake for method ReplicationProtectedItemsClient.BeginPurge
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginPurge func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginPurgeOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPurgeResponse], errResp azfake.ErrorResponder)

	// BeginRemoveDisks is the fake for method ReplicationProtectedItemsClient.BeginRemoveDisks
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRemoveDisks func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, removeDisksInput armrecoveryservicessiterecovery.RemoveDisksInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginRemoveDisksOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRemoveDisksResponse], errResp azfake.ErrorResponder)

	// BeginRepairReplication is the fake for method ReplicationProtectedItemsClient.BeginRepairReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRepairReplication func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginRepairReplicationOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRepairReplicationResponse], errResp azfake.ErrorResponder)

	// BeginReprotect is the fake for method ReplicationProtectedItemsClient.BeginReprotect
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReprotect func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, reprotectInput armrecoveryservicessiterecovery.ReverseReplicationInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginReprotectOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientReprotectResponse], errResp azfake.ErrorResponder)

	// BeginResolveHealthErrors is the fake for method ReplicationProtectedItemsClient.BeginResolveHealthErrors
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResolveHealthErrors func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, resolveHealthInput armrecoveryservicessiterecovery.ResolveHealthInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginResolveHealthErrorsOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientResolveHealthErrorsResponse], errResp azfake.ErrorResponder)

	// BeginSwitchProvider is the fake for method ReplicationProtectedItemsClient.BeginSwitchProvider
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSwitchProvider func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, switchProviderInput armrecoveryservicessiterecovery.SwitchProviderInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginSwitchProviderOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientSwitchProviderResponse], errResp azfake.ErrorResponder)

	// BeginTestFailover is the fake for method ReplicationProtectedItemsClient.BeginTestFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTestFailover func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, testfailoverInput armrecoveryservicessiterecovery.TestFailoverInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginTestFailoverOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverResponse], errResp azfake.ErrorResponder)

	// BeginTestFailoverCleanup is the fake for method ReplicationProtectedItemsClient.BeginTestFailoverCleanup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTestFailoverCleanup func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, cleanupInput armrecoveryservicessiterecovery.TestFailoverCleanupInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginTestFailoverCleanupOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverCleanupResponse], errResp azfake.ErrorResponder)

	// BeginUnplannedFailover is the fake for method ReplicationProtectedItemsClient.BeginUnplannedFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUnplannedFailover func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput armrecoveryservicessiterecovery.UnplannedFailoverInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginUnplannedFailoverOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUnplannedFailoverResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ReplicationProtectedItemsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, updateProtectionInput armrecoveryservicessiterecovery.UpdateReplicationProtectedItemInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginUpdateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAppliance is the fake for method ReplicationProtectedItemsClient.BeginUpdateAppliance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAppliance func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, applianceUpdateInput armrecoveryservicessiterecovery.UpdateApplianceForReplicationProtectedItemInput, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginUpdateApplianceOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateApplianceResponse], errResp azfake.ErrorResponder)

	// BeginUpdateMobilityService is the fake for method ReplicationProtectedItemsClient.BeginUpdateMobilityService
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateMobilityService func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, replicatedProtectedItemName string, updateMobilityServiceRequest armrecoveryservicessiterecovery.UpdateMobilityServiceRequest, options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientBeginUpdateMobilityServiceOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateMobilityServiceResponse], errResp azfake.ErrorResponder)
}

// NewReplicationProtectedItemsServerTransport creates a new instance of ReplicationProtectedItemsServerTransport with the provided implementation.
// The returned ReplicationProtectedItemsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationProtectedItemsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationProtectedItemsServerTransport(srv *ReplicationProtectedItemsServer) *ReplicationProtectedItemsServerTransport {
	return &ReplicationProtectedItemsServerTransport{
		srv:                     srv,
		beginAddDisks:           newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientAddDisksResponse]](),
		beginApplyRecoveryPoint: newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientApplyRecoveryPointResponse]](),
		beginCreate:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientCreateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientDeleteResponse]](),
		beginFailoverCancel:     newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCancelResponse]](),
		beginFailoverCommit:     newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCommitResponse]](),
		newListPager:            newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListResponse]](),
		newListByReplicationProtectionContainersPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListByReplicationProtectionContainersResponse]](),
		beginPlannedFailover:                          newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPlannedFailoverResponse]](),
		beginPurge:                                    newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPurgeResponse]](),
		beginRemoveDisks:                              newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRemoveDisksResponse]](),
		beginRepairReplication:                        newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRepairReplicationResponse]](),
		beginReprotect:                                newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientReprotectResponse]](),
		beginResolveHealthErrors:                      newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientResolveHealthErrorsResponse]](),
		beginSwitchProvider:                           newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientSwitchProviderResponse]](),
		beginTestFailover:                             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverResponse]](),
		beginTestFailoverCleanup:                      newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverCleanupResponse]](),
		beginUnplannedFailover:                        newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUnplannedFailoverResponse]](),
		beginUpdate:                                   newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateResponse]](),
		beginUpdateAppliance:                          newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateApplianceResponse]](),
		beginUpdateMobilityService:                    newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateMobilityServiceResponse]](),
	}
}

// ReplicationProtectedItemsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationProtectedItemsClient to instances of ReplicationProtectedItemsServer.
// Don't use this type directly, use NewReplicationProtectedItemsServerTransport instead.
type ReplicationProtectedItemsServerTransport struct {
	srv                                           *ReplicationProtectedItemsServer
	beginAddDisks                                 *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientAddDisksResponse]]
	beginApplyRecoveryPoint                       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientApplyRecoveryPointResponse]]
	beginCreate                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientCreateResponse]]
	beginDelete                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientDeleteResponse]]
	beginFailoverCancel                           *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCancelResponse]]
	beginFailoverCommit                           *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientFailoverCommitResponse]]
	newListPager                                  *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListResponse]]
	newListByReplicationProtectionContainersPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListByReplicationProtectionContainersResponse]]
	beginPlannedFailover                          *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPlannedFailoverResponse]]
	beginPurge                                    *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientPurgeResponse]]
	beginRemoveDisks                              *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRemoveDisksResponse]]
	beginRepairReplication                        *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientRepairReplicationResponse]]
	beginReprotect                                *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientReprotectResponse]]
	beginResolveHealthErrors                      *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientResolveHealthErrorsResponse]]
	beginSwitchProvider                           *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientSwitchProviderResponse]]
	beginTestFailover                             *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverResponse]]
	beginTestFailoverCleanup                      *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientTestFailoverCleanupResponse]]
	beginUnplannedFailover                        *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUnplannedFailoverResponse]]
	beginUpdate                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateResponse]]
	beginUpdateAppliance                          *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateApplianceResponse]]
	beginUpdateMobilityService                    *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectedItemsClientUpdateMobilityServiceResponse]]
}

// Do implements the policy.Transporter interface for ReplicationProtectedItemsServerTransport.
func (r *ReplicationProtectedItemsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationProtectedItemsClient.BeginAddDisks":
		resp, err = r.dispatchBeginAddDisks(req)
	case "ReplicationProtectedItemsClient.BeginApplyRecoveryPoint":
		resp, err = r.dispatchBeginApplyRecoveryPoint(req)
	case "ReplicationProtectedItemsClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReplicationProtectedItemsClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ReplicationProtectedItemsClient.BeginFailoverCancel":
		resp, err = r.dispatchBeginFailoverCancel(req)
	case "ReplicationProtectedItemsClient.BeginFailoverCommit":
		resp, err = r.dispatchBeginFailoverCommit(req)
	case "ReplicationProtectedItemsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationProtectedItemsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationProtectedItemsClient.NewListByReplicationProtectionContainersPager":
		resp, err = r.dispatchNewListByReplicationProtectionContainersPager(req)
	case "ReplicationProtectedItemsClient.BeginPlannedFailover":
		resp, err = r.dispatchBeginPlannedFailover(req)
	case "ReplicationProtectedItemsClient.BeginPurge":
		resp, err = r.dispatchBeginPurge(req)
	case "ReplicationProtectedItemsClient.BeginRemoveDisks":
		resp, err = r.dispatchBeginRemoveDisks(req)
	case "ReplicationProtectedItemsClient.BeginRepairReplication":
		resp, err = r.dispatchBeginRepairReplication(req)
	case "ReplicationProtectedItemsClient.BeginReprotect":
		resp, err = r.dispatchBeginReprotect(req)
	case "ReplicationProtectedItemsClient.BeginResolveHealthErrors":
		resp, err = r.dispatchBeginResolveHealthErrors(req)
	case "ReplicationProtectedItemsClient.BeginSwitchProvider":
		resp, err = r.dispatchBeginSwitchProvider(req)
	case "ReplicationProtectedItemsClient.BeginTestFailover":
		resp, err = r.dispatchBeginTestFailover(req)
	case "ReplicationProtectedItemsClient.BeginTestFailoverCleanup":
		resp, err = r.dispatchBeginTestFailoverCleanup(req)
	case "ReplicationProtectedItemsClient.BeginUnplannedFailover":
		resp, err = r.dispatchBeginUnplannedFailover(req)
	case "ReplicationProtectedItemsClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	case "ReplicationProtectedItemsClient.BeginUpdateAppliance":
		resp, err = r.dispatchBeginUpdateAppliance(req)
	case "ReplicationProtectedItemsClient.BeginUpdateMobilityService":
		resp, err = r.dispatchBeginUpdateMobilityService(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginAddDisks(req *http.Request) (*http.Response, error) {
	if r.srv.BeginAddDisks == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAddDisks not implemented")}
	}
	beginAddDisks := r.beginAddDisks.get(req)
	if beginAddDisks == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/addDisks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.AddDisksInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginAddDisks(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAddDisks = &respr
		r.beginAddDisks.add(req, beginAddDisks)
	}

	resp, err := server.PollerResponderNext(beginAddDisks, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginAddDisks.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAddDisks) {
		r.beginAddDisks.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginApplyRecoveryPoint(req *http.Request) (*http.Response, error) {
	if r.srv.BeginApplyRecoveryPoint == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginApplyRecoveryPoint not implemented")}
	}
	beginApplyRecoveryPoint := r.beginApplyRecoveryPoint.get(req)
	if beginApplyRecoveryPoint == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applyRecoveryPoint`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ApplyRecoveryPointInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginApplyRecoveryPoint(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginApplyRecoveryPoint = &respr
		r.beginApplyRecoveryPoint.add(req, beginApplyRecoveryPoint)
	}

	resp, err := server.PollerResponderNext(beginApplyRecoveryPoint, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginApplyRecoveryPoint.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginApplyRecoveryPoint) {
		r.beginApplyRecoveryPoint.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.EnableProtectionInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/remove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.DisableProtectionInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginFailoverCancel(req *http.Request) (*http.Response, error) {
	if r.srv.BeginFailoverCancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailoverCancel not implemented")}
	}
	beginFailoverCancel := r.beginFailoverCancel.get(req)
	if beginFailoverCancel == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverCancel`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginFailoverCancel(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailoverCancel = &respr
		r.beginFailoverCancel.add(req, beginFailoverCancel)
	}

	resp, err := server.PollerResponderNext(beginFailoverCancel, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginFailoverCancel.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailoverCancel) {
		r.beginFailoverCancel.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginFailoverCommit(req *http.Request) (*http.Response, error) {
	if r.srv.BeginFailoverCommit == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailoverCommit not implemented")}
	}
	beginFailoverCommit := r.beginFailoverCommit.get(req)
	if beginFailoverCommit == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failoverCommit`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginFailoverCommit(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailoverCommit = &respr
		r.beginFailoverCommit.add(req, beginFailoverCommit)
	}

	resp, err := server.PollerResponderNext(beginFailoverCommit, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginFailoverCommit.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailoverCommit) {
		r.beginFailoverCommit.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
	if err != nil {
		return nil, err
	}
	replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReplicationProtectedItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListOptions
		if skipTokenParam != nil || filterParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListOptions{
				SkipToken: skipTokenParam,
				Filter:    filterParam,
			}
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchNewListByReplicationProtectionContainersPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReplicationProtectionContainersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationProtectionContainersPager not implemented")}
	}
	newListByReplicationProtectionContainersPager := r.newListByReplicationProtectionContainersPager.get(req)
	if newListByReplicationProtectionContainersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByReplicationProtectionContainersPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, nil)
		newListByReplicationProtectionContainersPager = &resp
		r.newListByReplicationProtectionContainersPager.add(req, newListByReplicationProtectionContainersPager)
		server.PagerResponderInjectNextLinks(newListByReplicationProtectionContainersPager, req, func(page *armrecoveryservicessiterecovery.ReplicationProtectedItemsClientListByReplicationProtectionContainersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationProtectionContainersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReplicationProtectionContainersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationProtectionContainersPager) {
		r.newListByReplicationProtectionContainersPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginPlannedFailover(req *http.Request) (*http.Response, error) {
	if r.srv.BeginPlannedFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPlannedFailover not implemented")}
	}
	beginPlannedFailover := r.beginPlannedFailover.get(req)
	if beginPlannedFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/plannedFailover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.PlannedFailoverInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginPlannedFailover(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPlannedFailover = &respr
		r.beginPlannedFailover.add(req, beginPlannedFailover)
	}

	resp, err := server.PollerResponderNext(beginPlannedFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginPlannedFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPlannedFailover) {
		r.beginPlannedFailover.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginPurge(req *http.Request) (*http.Response, error) {
	if r.srv.BeginPurge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPurge not implemented")}
	}
	beginPurge := r.beginPurge.get(req)
	if beginPurge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginPurge(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPurge = &respr
		r.beginPurge.add(req, beginPurge)
	}

	resp, err := server.PollerResponderNext(beginPurge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginPurge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPurge) {
		r.beginPurge.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginRemoveDisks(req *http.Request) (*http.Response, error) {
	if r.srv.BeginRemoveDisks == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRemoveDisks not implemented")}
	}
	beginRemoveDisks := r.beginRemoveDisks.get(req)
	if beginRemoveDisks == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/removeDisks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.RemoveDisksInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginRemoveDisks(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRemoveDisks = &respr
		r.beginRemoveDisks.add(req, beginRemoveDisks)
	}

	resp, err := server.PollerResponderNext(beginRemoveDisks, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginRemoveDisks.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRemoveDisks) {
		r.beginRemoveDisks.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginRepairReplication(req *http.Request) (*http.Response, error) {
	if r.srv.BeginRepairReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRepairReplication not implemented")}
	}
	beginRepairReplication := r.beginRepairReplication.get(req)
	if beginRepairReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/repairReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginRepairReplication(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRepairReplication = &respr
		r.beginRepairReplication.add(req, beginRepairReplication)
	}

	resp, err := server.PollerResponderNext(beginRepairReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginRepairReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRepairReplication) {
		r.beginRepairReplication.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginReprotect(req *http.Request) (*http.Response, error) {
	if r.srv.BeginReprotect == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReprotect not implemented")}
	}
	beginReprotect := r.beginReprotect.get(req)
	if beginReprotect == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reProtect`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ReverseReplicationInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginReprotect(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReprotect = &respr
		r.beginReprotect.add(req, beginReprotect)
	}

	resp, err := server.PollerResponderNext(beginReprotect, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginReprotect.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReprotect) {
		r.beginReprotect.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginResolveHealthErrors(req *http.Request) (*http.Response, error) {
	if r.srv.BeginResolveHealthErrors == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResolveHealthErrors not implemented")}
	}
	beginResolveHealthErrors := r.beginResolveHealthErrors.get(req)
	if beginResolveHealthErrors == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resolveHealthErrors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ResolveHealthInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginResolveHealthErrors(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResolveHealthErrors = &respr
		r.beginResolveHealthErrors.add(req, beginResolveHealthErrors)
	}

	resp, err := server.PollerResponderNext(beginResolveHealthErrors, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginResolveHealthErrors.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResolveHealthErrors) {
		r.beginResolveHealthErrors.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginSwitchProvider(req *http.Request) (*http.Response, error) {
	if r.srv.BeginSwitchProvider == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSwitchProvider not implemented")}
	}
	beginSwitchProvider := r.beginSwitchProvider.get(req)
	if beginSwitchProvider == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/switchProvider`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.SwitchProviderInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginSwitchProvider(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSwitchProvider = &respr
		r.beginSwitchProvider.add(req, beginSwitchProvider)
	}

	resp, err := server.PollerResponderNext(beginSwitchProvider, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginSwitchProvider.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSwitchProvider) {
		r.beginSwitchProvider.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginTestFailover(req *http.Request) (*http.Response, error) {
	if r.srv.BeginTestFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTestFailover not implemented")}
	}
	beginTestFailover := r.beginTestFailover.get(req)
	if beginTestFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testFailover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.TestFailoverInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginTestFailover(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTestFailover = &respr
		r.beginTestFailover.add(req, beginTestFailover)
	}

	resp, err := server.PollerResponderNext(beginTestFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginTestFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTestFailover) {
		r.beginTestFailover.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginTestFailoverCleanup(req *http.Request) (*http.Response, error) {
	if r.srv.BeginTestFailoverCleanup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTestFailoverCleanup not implemented")}
	}
	beginTestFailoverCleanup := r.beginTestFailoverCleanup.get(req)
	if beginTestFailoverCleanup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testFailoverCleanup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.TestFailoverCleanupInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginTestFailoverCleanup(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTestFailoverCleanup = &respr
		r.beginTestFailoverCleanup.add(req, beginTestFailoverCleanup)
	}

	resp, err := server.PollerResponderNext(beginTestFailoverCleanup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginTestFailoverCleanup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTestFailoverCleanup) {
		r.beginTestFailoverCleanup.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginUnplannedFailover(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUnplannedFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUnplannedFailover not implemented")}
	}
	beginUnplannedFailover := r.beginUnplannedFailover.get(req)
	if beginUnplannedFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/unplannedFailover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UnplannedFailoverInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUnplannedFailover(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUnplannedFailover = &respr
		r.beginUnplannedFailover.add(req, beginUnplannedFailover)
	}

	resp, err := server.PollerResponderNext(beginUnplannedFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUnplannedFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUnplannedFailover) {
		r.beginUnplannedFailover.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UpdateReplicationProtectedItemInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginUpdateAppliance(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdateAppliance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAppliance not implemented")}
	}
	beginUpdateAppliance := r.beginUpdateAppliance.get(req)
	if beginUpdateAppliance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateAppliance`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UpdateApplianceForReplicationProtectedItemInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdateAppliance(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAppliance = &respr
		r.beginUpdateAppliance.add(req, beginUpdateAppliance)
	}

	resp, err := server.PollerResponderNext(beginUpdateAppliance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdateAppliance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAppliance) {
		r.beginUpdateAppliance.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectedItemsServerTransport) dispatchBeginUpdateMobilityService(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdateMobilityService == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateMobilityService not implemented")}
	}
	beginUpdateMobilityService := r.beginUpdateMobilityService.get(req)
	if beginUpdateMobilityService == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectedItems/(?P<replicatedProtectedItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateMobilityService`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UpdateMobilityServiceRequest](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		replicatedProtectedItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("replicatedProtectedItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdateMobilityService(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, replicatedProtectedItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateMobilityService = &respr
		r.beginUpdateMobilityService.add(req, beginUpdateMobilityService)
	}

	resp, err := server.PollerResponderNext(beginUpdateMobilityService, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdateMobilityService.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateMobilityService) {
		r.beginUpdateMobilityService.remove(req)
	}

	return resp, nil
}
