//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armresourcegraph_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcegraph/armresourcegraph"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesPropertiesQuery.json
func ExampleClient_Resources_accessAPropertiesField() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | where type =~ 'Microsoft.Compute/virtualMachines' | summarize count() by tostring(properties.storageProfile.osDisk.osType)"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](2),
	// 	Data: []any{
	// 		map[string]any{
	// 			"count": float64(7),
	// 			"properties_storageProfile_osDisk_osType": "Linux",
	// 		},
	// 		map[string]any{
	// 			"count": float64(23),
	// 			"properties_storageProfile_osDisk_osType": "Windows",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](2),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesMgBasicQuery.json
func ExampleClient_Resources_basicManagementGroupQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		ManagementGroups: []*string{
			to.Ptr("e927f598-c1d4-4f72-8541-95d83a6a4ac8"),
			to.Ptr("ProductionMG")},
		Query: to.Ptr("Resources | project id, name, type, location, tags | limit 3"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "myNetworkInterface",
	// 			"type": "microsoft.network/networkinterfaces",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Network/networkInterfaces/myNetworkInterface",
	// 			"location": "centralus",
	// 			"tags":map[string]any{
	// 				"tag1": "Value1",
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myVnet",
	// 			"type": "microsoft.network/virtualnetworks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/virtualNetworks/myVnet",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myPublicIp",
	// 			"type": "microsoft.network/publicipaddresses",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/publicIPAddresses/myPublicIp",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesBasicQuery.json
func ExampleClient_Resources_basicQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | project id, name, type, location, tags | limit 3"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "myNetworkInterface",
	// 			"type": "microsoft.network/networkinterfaces",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Network/networkInterfaces/myNetworkInterface",
	// 			"location": "centralus",
	// 			"tags":map[string]any{
	// 				"tag1": "Value1",
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myVnet",
	// 			"type": "microsoft.network/virtualnetworks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/virtualNetworks/myVnet",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myPublicIp",
	// 			"type": "microsoft.network/publicipaddresses",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/publicIPAddresses/myPublicIp",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesTenantBasicQuery.json
func ExampleClient_Resources_basicTenantQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | project id, name, type, location, tags | limit 3"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "myNetworkInterface",
	// 			"type": "microsoft.network/networkinterfaces",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Network/networkInterfaces/myNetworkInterface",
	// 			"location": "centralus",
	// 			"tags":map[string]any{
	// 				"tag1": "Value1",
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myVnet",
	// 			"type": "microsoft.network/virtualnetworks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/virtualNetworks/myVnet",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 		map[string]any{
	// 			"name": "myPublicIp",
	// 			"type": "microsoft.network/publicipaddresses",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Network/publicIPAddresses/myPublicIp",
	// 			"location": "westus",
	// 			"tags":map[string]any{
	// 			},
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesComplexQuery.json
func ExampleClient_Resources_complexQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | project id, name, type, location | where type =~ 'Microsoft.Compute/virtualMachines' | summarize count() by location | top 3 by count_"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"count_": float64(11),
	// 			"location": "centralus",
	// 		},
	// 		map[string]any{
	// 			"count_": float64(11),
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"count_": float64(3),
	// 			"location": "southcentralus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFilterQuery.json
func ExampleClient_Resources_filterResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | project id, name, type, location | where type =~ 'Microsoft.Compute/virtualMachines' | limit 3"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "myVm1",
	// 			"type": "microsoft.compute/virtualmachines",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Compute/virtualMachines/myVm1",
	// 			"location": "centralus",
	// 		},
	// 		map[string]any{
	// 			"name": "myVirtualMachine",
	// 			"type": "microsoft.compute/virtualmachines",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Compute/virtualMachines/myVirtualMachine",
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"name": "testVm",
	// 			"type": "microsoft.compute/virtualmachines",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG3/providers/Microsoft.Compute/virtualMachines/testVm",
	// 			"location": "eastus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFirstPageQuery.json
func ExampleClient_Resources_firstPageQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Options: &armresourcegraph.QueryRequestOptions{
			Skip: to.Ptr[int32](0),
			Top:  to.Ptr[int32](3),
		},
		Query: to.Ptr("Resources | where name contains 'test' | project id, name, type, location"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	SkipToken: to.Ptr("eyAibm8iOiAibHVjayIsICJidXQiOiAibmljZSIsICJ0cnkiOiAiISIgfQ=="),
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "yetanothertest_OsDisk_1_f396cbcb625a457bb69fe2abf5975820",
	// 			"type": "microsoft.compute/disks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Compute/disks/yetanothertest_OsDisk_1_f396cbcb625a457bb69fe2abf5975820",
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"name": "TestAA",
	// 			"type": "microsoft.automation/automationaccounts",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Automation/automationAccounts/TestAA",
	// 			"location": "westcentralus",
	// 		},
	// 		map[string]any{
	// 			"name": "TestRB",
	// 			"type": "microsoft.automation/automationaccounts/runbooks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Automation/automationAccounts/TestAA/runbooks/TestRB",
	// 			"location": "westcentralus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](386),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesNextPageQuery.json
func ExampleClient_Resources_nextPageQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Options: &armresourcegraph.QueryRequestOptions{
			SkipToken: to.Ptr("eyAibm8iOiAibHVjayIsICJidXQiOiAibmljZSIsICJ0cnkiOiAiISIgfQ=="),
		},
		Query: to.Ptr("Resources | where name contains 'test' | project id, name, type, location"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	SkipToken: to.Ptr("eyAibm8yIjogImx1Y2syIiwgImJ1dDIiOiAibmljZTIiLCAidHJ5MiI6ICIhIiB9"),
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "second_OsDisk_dddddbcb625a457bb69fe2abf5975820",
	// 			"type": "microsoft.compute/disks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Compute/disks/second_OsDisk_dddddbcb625a457bb69fe2abf5975820",
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"name": "AATest",
	// 			"type": "microsoft.automation/automationaccounts",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Automation/automationAccounts/AATest",
	// 			"location": "westcentralus",
	// 		},
	// 		map[string]any{
	// 			"name": "RBTest",
	// 			"type": "microsoft.automation/automationaccounts/runbooks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Automation/automationAccounts/TestAA/runbooks/RBTest",
	// 			"location": "westcentralus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](386),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesFacetQuery.json
func ExampleClient_Resources_queryWithAFacetRequest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Facets: []*armresourcegraph.FacetRequest{
			{
				Expression: to.Ptr("location"),
				Options: &armresourcegraph.FacetRequestOptions{
					Top:       to.Ptr[int32](3),
					SortOrder: to.Ptr(armresourcegraph.FacetSortOrderDesc),
				},
			},
			{
				Expression: to.Ptr("properties.storageProfile.osDisk.osType"),
				Options: &armresourcegraph.FacetRequestOptions{
					Top:       to.Ptr[int32](3),
					SortOrder: to.Ptr(armresourcegraph.FacetSortOrderDesc),
				},
			},
			{
				Expression: to.Ptr("nonExistingColumn"),
				Options: &armresourcegraph.FacetRequestOptions{
					Top:       to.Ptr[int32](3),
					SortOrder: to.Ptr(armresourcegraph.FacetSortOrderDesc),
				},
			},
			{
				Expression: to.Ptr("resourceGroup"),
				Options: &armresourcegraph.FacetRequestOptions{
					Top:       to.Ptr[int32](3),
					SortBy:    to.Ptr("tolower(resourceGroup)"),
					SortOrder: to.Ptr(armresourcegraph.FacetSortOrderAsc),
				},
			},
			{
				Expression: to.Ptr("resourceGroup"),
				Options: &armresourcegraph.FacetRequestOptions{
					Top:    to.Ptr[int32](3),
					Filter: to.Ptr("resourceGroup contains 'test'"),
				},
			}},
		Query: to.Ptr("Resources | where type =~ 'Microsoft.Compute/virtualMachines' | project id, name, location, resourceGroup, properties.storageProfile.osDisk.osType | limit 5"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](5),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "myTestVm",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/B-TEST-RG/providers/Microsoft.Compute/virtualMachines/myTestVm",
	// 			"location": "eastus",
	// 			"properties_storageProfile_osDisk_osType": "Windows",
	// 			"resourceGroup": "B-TEST-RG",
	// 		},
	// 		map[string]any{
	// 			"name": "myTestAccountVm",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/c-rg/providers/Microsoft.Compute/virtualMachines/myTestAccountVm",
	// 			"location": "westcentralus",
	// 			"properties_storageProfile_osDisk_osType": "Windows",
	// 			"resourceGroup": "c-rg",
	// 		},
	// 		map[string]any{
	// 			"name": "yetanothertest",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/I-RG/providers/Microsoft.Compute/virtualMachines/yetanothertest",
	// 			"location": "eastus",
	// 			"properties_storageProfile_osDisk_osType": "Linux",
	// 			"resourceGroup": "I-RG",
	// 		},
	// 		map[string]any{
	// 			"name": "drafttest1bux4cv7a7q3aw",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/x-test-rg/providers/Microsoft.Compute/virtualMachines/drafttest1bux4cv7a7q3aw",
	// 			"location": "southcentralus",
	// 			"properties_storageProfile_osDisk_osType": "Linux",
	// 			"resourceGroup": "x-test-rg",
	// 		},
	// 		map[string]any{
	// 			"name": "testvmntp25370",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/y-rg/providers/Microsoft.Compute/virtualMachines/testvmntp25370",
	// 			"location": "eastus",
	// 			"properties_storageProfile_osDisk_osType": "Windows",
	// 			"resourceGroup": "y-rg",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 		&armresourcegraph.FacetResult{
	// 			Expression: to.Ptr("location"),
	// 			ResultType: to.Ptr("FacetResult"),
	// 			Count: to.Ptr[int32](3),
	// 			Data: []any{
	// 				map[string]any{
	// 					"count": float64(3),
	// 					"location": "eastus",
	// 				},
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"location": "southcentralus",
	// 				},
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"location": "westcentralus",
	// 				},
	// 			},
	// 			TotalRecords: to.Ptr[int64](3),
	// 		},
	// 		&armresourcegraph.FacetResult{
	// 			Expression: to.Ptr("properties.storageProfile.osDisk.osType"),
	// 			ResultType: to.Ptr("FacetResult"),
	// 			Count: to.Ptr[int32](2),
	// 			Data: []any{
	// 				map[string]any{
	// 					"count": float64(2),
	// 					"properties_storageProfile_osDisk_osType": "Linux",
	// 				},
	// 				map[string]any{
	// 					"count": float64(3),
	// 					"properties_storageProfile_osDisk_osType": "Windows",
	// 				},
	// 			},
	// 			TotalRecords: to.Ptr[int64](2),
	// 		},
	// 		&armresourcegraph.FacetError{
	// 			Expression: to.Ptr("nonExistingColumn"),
	// 			ResultType: to.Ptr("FacetError"),
	// 			Errors: []*armresourcegraph.ErrorDetails{
	// 				{
	// 					Code: to.Ptr("NoValidColumns"),
	// 					Message: to.Ptr("No valid columns in facet expression."),
	// 				},
	// 				{
	// 					Code: to.Ptr("InvalidColumnNames"),
	// 					Message: to.Ptr("Invalid column names: [nonExistingColumn]."),
	// 			}},
	// 		},
	// 		&armresourcegraph.FacetResult{
	// 			Expression: to.Ptr("resourceGroup"),
	// 			ResultType: to.Ptr("FacetResult"),
	// 			Count: to.Ptr[int32](3),
	// 			Data: []any{
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"resourceGroup": "B-TEST-RG",
	// 				},
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"resourceGroup": "c-rg",
	// 				},
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"resourceGroup": "I-RG",
	// 				},
	// 			},
	// 			TotalRecords: to.Ptr[int64](5),
	// 		},
	// 		&armresourcegraph.FacetResult{
	// 			Expression: to.Ptr("resourceGroup"),
	// 			ResultType: to.Ptr("FacetResult"),
	// 			Count: to.Ptr[int32](2),
	// 			Data: []any{
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"resourceGroup": "B-TEST-RG",
	// 				},
	// 				map[string]any{
	// 					"count": float64(1),
	// 					"resourceGroup": "x-test-rg",
	// 				},
	// 			},
	// 			TotalRecords: to.Ptr[int64](2),
	// 	}},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](5),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesRandomPageQuery.json
func ExampleClient_Resources_randomPageQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Options: &armresourcegraph.QueryRequestOptions{
			Skip: to.Ptr[int32](10),
			Top:  to.Ptr[int32](2),
		},
		Query: to.Ptr("Resources | where name contains 'test' | project id, name, type, location"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	SkipToken: to.Ptr("eyAibm8iOiAibHVjayIsICJidXQiOiAibmljZSIsICJ0cnkiOiAiISIgfQ=="),
	// 	Count: to.Ptr[int64](2),
	// 	Data: []any{
	// 		map[string]any{
	// 			"name": "third_OsDisk_dddddbcb625a457bb69fe2abf5975820",
	// 			"type": "microsoft.compute/disks",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG1/providers/Microsoft.Compute/disks/third_OsDisk_dddddbcb625a457bb69fe2abf5975820",
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"name": "CCTest",
	// 			"type": "microsoft.automation/automationaccounts",
	// 			"id": "/subscriptions/cfbbd179-59d2-4052-aa06-9270a38aa9d6/resourceGroups/RG2/providers/Microsoft.Automation/automationAccounts/CCTest",
	// 			"location": "westcentralus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](386),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesSummarizeQuery.json
func ExampleClient_Resources_summarizeResourcesByLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Resources(ctx, armresourcegraph.QueryRequest{
		Query: to.Ptr("Resources | project id, name, type, location | summarize by location"),
		Subscriptions: []*string{
			to.Ptr("cfbbd179-59d2-4052-aa06-9270a38aa9d6")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryResponse = armresourcegraph.QueryResponse{
	// 	Count: to.Ptr[int64](3),
	// 	Data: []any{
	// 		map[string]any{
	// 			"location": "centralus",
	// 		},
	// 		map[string]any{
	// 			"location": "eastus",
	// 		},
	// 		map[string]any{
	// 			"location": "westus",
	// 		},
	// 	},
	// 	Facets: []armresourcegraph.FacetClassification{
	// 	},
	// 	ResultTruncated: to.Ptr(armresourcegraph.ResultTruncatedFalse),
	// 	TotalRecords: to.Ptr[int64](3),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesHistoryMgsGet.json
func ExampleClient_ResourcesHistory_resourceHistoryManagementGroupScopeQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ResourcesHistory(ctx, armresourcegraph.ResourcesHistoryRequest{
		ManagementGroups: []*string{
			to.Ptr("e927f598-c1d4-4f72-8541-95d83a6a4ac8"),
			to.Ptr("ProductionMG")},
		Options: &armresourcegraph.ResourcesHistoryRequestOptions{
			Interval: &armresourcegraph.DateTimeInterval{
				End:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-12T01:25:00.000Z"); return t }()),
				Start: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-12T01:00:00.000Z"); return t }()),
			},
		},
		Query: to.Ptr("where name =~ 'cpu-utilization' | project id, name, properties"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// 	"count": float64(2),
	// 	"snapshots":map[string]any{
	// 		"columns":[]any{
	// 			map[string]any{
	// 				"name": "id",
	// 				"type": "string",
	// 			},
	// 			map[string]any{
	// 				"name": "name",
	// 				"type": "string",
	// 			},
	// 			map[string]any{
	// 				"name": "properties",
	// 				"type": "object",
	// 			},
	// 		},
	// 		"rows":[]any{
	// 			[]any{
	// 				"/subscriptions/a7f33fdb-e646-4f15-89aa-3a360210861e/resourceGroups/meya-test-rg/providers/Microsoft.Compute/virtualMachines/meya-win-eus/providers/Microsoft.WorkloadMonitor/monitors/cpu-utilization",
	// 				"cpu-utilization",
	// 				map[string]any{
	// 					"currentStateFirstObservedTimestamp": "",
	// 					"monitorName": "",
	// 				},
	// 			},
	// 			[]any{
	// 				"/subscriptions/a7f33fdb-e646-4f15-89aa-3a360210861e/resourceGroups/meya-test-rg/providers/Microsoft.Compute/virtualMachines/meya-win-eus/providers/Microsoft.WorkloadMonitor/monitors/cpu-utilization",
	// 				"cpu-utilization",
	// 				map[string]any{
	// 					"currentStateFirstObservedTimestamp": "",
	// 					"monitorName": "test",
	// 				},
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/resourcegraph/resource-manager/Microsoft.ResourceGraph/preview/2021-06-01-preview/examples/ResourcesHistoryGet.json
func ExampleClient_ResourcesHistory_resourceHistoryQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armresourcegraph.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ResourcesHistory(ctx, armresourcegraph.ResourcesHistoryRequest{
		Options: &armresourcegraph.ResourcesHistoryRequestOptions{
			Interval: &armresourcegraph.DateTimeInterval{
				End:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-12T01:25:00.000Z"); return t }()),
				Start: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-12T01:00:00.000Z"); return t }()),
			},
		},
		Query: to.Ptr("where name =~ 'cpu-utilization' | project id, name, properties"),
		Subscriptions: []*string{
			to.Ptr("a7f33fdb-e646-4f15-89aa-3a360210861e")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// 	"count": float64(2),
	// 	"snapshots":map[string]any{
	// 		"columns":[]any{
	// 			map[string]any{
	// 				"name": "id",
	// 				"type": "string",
	// 			},
	// 			map[string]any{
	// 				"name": "name",
	// 				"type": "string",
	// 			},
	// 			map[string]any{
	// 				"name": "properties",
	// 				"type": "object",
	// 			},
	// 		},
	// 		"rows":[]any{
	// 			[]any{
	// 				"/subscriptions/a7f33fdb-e646-4f15-89aa-3a360210861e/resourceGroups/meya-test-rg/providers/Microsoft.Compute/virtualMachines/meya-win-eus/providers/Microsoft.WorkloadMonitor/monitors/cpu-utilization",
	// 				"cpu-utilization",
	// 				map[string]any{
	// 					"currentStateFirstObservedTimestamp": "",
	// 					"monitorName": "",
	// 				},
	// 			},
	// 			[]any{
	// 				"/subscriptions/a7f33fdb-e646-4f15-89aa-3a360210861e/resourceGroups/meya-test-rg/providers/Microsoft.Compute/virtualMachines/meya-win-eus/providers/Microsoft.WorkloadMonitor/monitors/cpu-utilization",
	// 				"cpu-utilization",
	// 				map[string]any{
	// 					"currentStateFirstObservedTimestamp": "",
	// 					"monitorName": "test",
	// 				},
	// 			},
	// 		},
	// 	},
	// }
}
