/*
    SPDX-FileCopyrightText: 2007-2019 Thomas Baumgart <ipwizard@users.sourceforge.net>
    SPDX-FileCopyrightText: 2017-2018 Łukasz Wojniłowicz <lukasz.wojnilowicz@gmail.com>
    SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef KACCOUNTSVIEW_H
#define KACCOUNTSVIEW_H

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneyviewbase.h"

class MyMoneyMoney;
class MyMoneyAccount;
class MyMoneyObject;
class SelectedObjects;

namespace eMenu {
enum class Action;
}
namespace KMyMoneyPlugin {
class OnlinePlugin;
}

template <class Key, class Value> class QMap;

/**
  * This class implements the accounts hierarchical and iconic 'view'.
  */

class KAccountsViewPrivate;
class KAccountsView : public KMyMoneyViewBase
{
    Q_OBJECT

public:
    explicit KAccountsView(QWidget *parent = nullptr);
    ~KAccountsView();

    void refresh();

public Q_SLOTS:
    void slotNetWorthChanged(const MyMoneyMoney &netWorth, bool isApproximate);

    void slotSettingsChanged() override;
    void updateActions(const SelectedObjects& selections) override;

    virtual void setOnlinePlugins(QMap<QString, KMyMoneyPlugin::OnlinePlugin*>* plugins) override;

private:
    Q_DECLARE_PRIVATE(KAccountsView)

private Q_SLOTS:
    void slotUnusedIncomeExpenseAccountHidden();
    void slotNewAccount();
    void slotEditAccount();
    void slotDeleteAccount();
    void slotNewCategory();
    void slotNewPayee(const QString& nameBase, QString& id);
    void slotAccountMapOnline();
    void slotAccountUnmapOnline();
    void slotAccountUpdateOnline();
    void slotAccountUpdateOnlineAll();

Q_SIGNALS:
    void beginImportingStatements();
    void endImportingStatements();
};

#endif
