; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test file to verify the emission of Vector selection instructions when ternary operators are used.

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; RUN: llc -verify-machineinstrs -mcpu=pwr10 -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names --ppc-vsr-nums-as-vr < %s | FileCheck %s

; Function to test ternary(A, and(B, C), nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_and_BC_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_and_BC_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 129
; CHECK-NEXT:    blr
entry:
  %and = and <4 x i32> %B, %C
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %and, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, and(B, C), nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_and_BC_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_and_BC_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 129
; CHECK-NEXT:    blr
entry:
  %and = and <2 x i64> %B, %C
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %and, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, and(B, C), nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_and_BC_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_and_BC_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 129
; CHECK-NEXT:    blr
entry:
  %and = and <16 x i8> %B, %C
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %and, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, and(B, C), nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_and_BC_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_and_BC_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 129
; CHECK-NEXT:    blr
entry:
  %and = and <8 x i16> %B, %C
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %and, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, B, nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_B_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_B_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 131
; CHECK-NEXT:    blr
entry:
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %B, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, B, nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_B_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_B_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 131
; CHECK-NEXT:    blr
entry:
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %B, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, B, nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_B_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_B_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 131
; CHECK-NEXT:    blr
entry:
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %B, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, B, nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_B_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_B_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 131
; CHECK-NEXT:    blr
entry:
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %B, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, C, nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_C_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_C_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 133
; CHECK-NEXT:    blr
entry:
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %C, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, C, nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_C_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_C_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 133
; CHECK-NEXT:    blr
entry:
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %C, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, C, nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_C_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_C_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 133
; CHECK-NEXT:    blr
entry:
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %C, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, C, nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_C_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_C_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 133
; CHECK-NEXT:    blr
entry:
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %C, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, xor(B,C), nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_xor_BC_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_xor_BC_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 134
; CHECK-NEXT:    blr
entry:
  %xor = xor <4 x i32> %B, %C
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %xor, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, xor(B,C), nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_xor_BC_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_xor_BC_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 134
; CHECK-NEXT:    blr
entry:
  %xor = xor <2 x i64> %B, %C
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %xor, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, xor(B,C), nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_xor_BC_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_xor_BC_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 134
; CHECK-NEXT:    blr
entry:
  %xor = xor <16 x i8> %B, %C
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %xor, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, xor(B,C), nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_xor_BC_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_xor_BC_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 134
; CHECK-NEXT:    blr
entry:
  %xor = xor <8 x i16> %B, %C
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %xor, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, not(C), nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_not_C_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_not_C_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 138
; CHECK-NEXT:    blr
entry:
  %not = xor <4 x i32> %C, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector not operation
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %not, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, not(C), nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_not_C_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_not_C_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 138
; CHECK-NEXT:    blr
entry:
  %not = xor <2 x i64> %C, <i64 -1, i64 -1>  ; Vector not operation
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %not, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, not(C), nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_not_C_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_not_C_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 138
; CHECK-NEXT:    blr
entry:
  %not = xor <16 x i8> %C, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector not operation
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %not, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, not(C), nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_not_C_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_not_C_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 138
; CHECK-NEXT:    blr
entry:
  %not = xor <8 x i16> %C, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector not operation
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %not, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, not(B), nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_not_B_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_not_B_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 140
; CHECK-NEXT:    blr
entry:
  %not = xor <4 x i32> %B, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector not operation
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %not, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, not(B), nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_not_B_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_not_B_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 140
; CHECK-NEXT:    blr
entry:
  %not = xor <2 x i64> %B, <i64 -1, i64 -1>  ; Vector not operation
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %not, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, not(B), nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_not_B_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_not_B_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 140
; CHECK-NEXT:    blr
entry:
  %not = xor <16 x i8> %B, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector not operation
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %not, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, not(B), nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_not_B_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_not_B_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 140
; CHECK-NEXT:    blr
entry:
  %not = xor <8 x i16> %B, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector not operation
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %not, <8 x i16> %nor
  ret <8 x i16> %res
}

; Function to test ternary(A, nand(B,C), nor(B,C)) for <4 x i32>
define <4 x i32> @ternary_A_nand_BC_nor_BC_4x32(<4 x i1> %A, <4 x i32> %B, <4 x i32> %C) {
; CHECK-LABEL: ternary_A_nand_BC_nor_BC_4x32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxleqv v5, v5, v5
; CHECK-NEXT:    vslw v2, v2, v5
; CHECK-NEXT:    vsraw v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 142
; CHECK-NEXT:    blr
entry:
  %and = and <4 x i32> %B, %C
  %nand = xor <4 x i32> %and, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector nand operation
  %or = or <4 x i32> %B, %C
  %nor = xor <4 x i32> %or, <i32 -1, i32 -1, i32 -1, i32 -1>  ; Vector NOR operation
  %res = select <4 x i1> %A, <4 x i32> %nand, <4 x i32> %nor
  ret <4 x i32> %res
}

; Function to test ternary(A, nand(B,C), nor(B,C)) for <2 x i64>
define <2 x i64> @ternary_A_nand_BC_nor_BC_2x64(<2 x i1> %A, <2 x i64> %B, <2 x i64> %C) {
; CHECK-LABEL: ternary_A_nand_BC_nor_BC_2x64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxlxor v5, v5, v5
; CHECK-NEXT:    xxsplti32dx v5, 1, 63
; CHECK-NEXT:    vsld v2, v2, v5
; CHECK-NEXT:    vsrad v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 142
; CHECK-NEXT:    blr
entry:
  %and = and <2 x i64> %B, %C
  %nand = xor <2 x i64> %and, <i64 -1, i64 -1>  ; Vector nand operation
  %or = or <2 x i64> %B, %C
  %nor = xor <2 x i64> %or, <i64 -1, i64 -1>  ; Vector NOR operation
  %res = select <2 x i1> %A, <2 x i64> %nand, <2 x i64> %nor
  ret <2 x i64> %res
}

; Function to test ternary(A, nand(B,C), nor(B,C)) for <16 x i8>
define <16 x i8> @ternary_A_nand_BC_nor_BC_16x8(<16 x i1> %A, <16 x i8> %B, <16 x i8> %C) {
; CHECK-LABEL: ternary_A_nand_BC_nor_BC_16x8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltib v5, 7
; CHECK-NEXT:    vslb v2, v2, v5
; CHECK-NEXT:    vsrab v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 142
; CHECK-NEXT:    blr
entry:
  %and = and <16 x i8> %B, %C
  %nand = xor <16 x i8> %and, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector nand operation
  %or = or <16 x i8> %B, %C
  %nor = xor <16 x i8> %or, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>  ; Vector NOR operation
  %res = select <16 x i1> %A, <16 x i8> %nand, <16 x i8> %nor
  ret <16 x i8> %res
}

; Function to test ternary(A, nand(B,C), nor(B,C)) for <8 x i16>
define <8 x i16> @ternary_A_nand_BC_nor_BC_8x16(<8 x i1> %A, <8 x i16> %B, <8 x i16> %C) {
; CHECK-LABEL: ternary_A_nand_BC_nor_BC_8x16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxspltiw v5, 983055
; CHECK-NEXT:    vslh v2, v2, v5
; CHECK-NEXT:    vsrah v2, v2, v5
; CHECK-NEXT:    xxeval v2, v2, v3, v4, 142
; CHECK-NEXT:    blr
entry:
  %and = and <8 x i16> %B, %C
  %nand = xor <8 x i16> %and, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector nand operation
  %or = or <8 x i16> %B, %C
  %nor = xor <8 x i16> %or, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>  ; Vector NOR operation
  %res = select <8 x i1> %A, <8 x i16> %nand, <8 x i16> %nor
  ret <8 x i16> %res
}
