// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <OpenFOAMPluginInfo.h>
#include <avtOpenFOAMFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtOpenFOAMOptions.h>

// ****************************************************************************
//  Method:  OpenFOAMCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a OpenFOAM database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
OpenFOAMCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: OpenFOAMCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a OpenFOAM database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A OpenFOAM database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
OpenFOAMCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    // ignore any nBlocks past 1
    int nTimestepGroups = nList / nBlock;
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtOpenFOAMFileFormat(list[i*nBlock], readOptions);
    }
    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, nTimestepGroups);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: OpenFOAMCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
OpenFOAMCommonPluginInfo::GetReadOptions() const
{
    return GetOpenFOAMReadOptions();
}

// ****************************************************************************
//  Method: OpenFOAMCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
OpenFOAMCommonPluginInfo::GetWriteOptions() const
{
    return GetOpenFOAMWriteOptions();
}

