title: The 66 Suite: 66-shutdownd
author: Eric Vidal <eric@obarun.org>

[66](index.html)

[Software](https://web.obarun.org/software)

[obarun.org](https://web.obarun.org)

# 66-shutdownd

The daemon that manages the shutdown procedure for a [66 boot](66-boot.html) initialization. It is not meant to be called directly and automatically generated by a [66 scandir create|start](66-scandir.html) command invocation.

This program is a modified copy of [s6-linux-init-shudownd](https://skarnet.org/software/s6-linux-init/s6-linux-init-shutdownd.html).

## Interface

```
66-shutdownd [ -h ] [ -l live ] [ -s skel ] [ -g gracetime ] [ -B ] [ -c ]
```

- 66-shutdownd opens the `%%livedir%%/scandir/0/shutdownd/fifo` pipe and listens to it. Programs such as [66-shutdown](66-shutdown.html) send their commands to this pipe when they are told to trigger the shutdown procedure.

- When it receives a command to shut down *66-shutdownd* parses the skel file `rc.init`—defined by default at `%%skel%%` directory— and reads the value of `RCSHUTDOWN` to be able to spawn the `rc.shutdown` script.

- When said script exits *66-shutdownd* kills all processes first with a `SIGTERM` then, after the grace time specified by the shutdown command, with a `SIGKILL`.

- It then runs an automatically generated script called `stage4` which unmounts all file systems and halts, powers off or reboots the machine.

## Options

- **-h**: prints this help.

- **-l** *live*: changes the supervision directory of *service* to *live*. By default this will be `%%livedir%%`. The default can also be changed at compile time by passing the `--livedir=live` option to `./configure`. An existing absolute path is expected and should be within a writable and executable filesystem - likely a RAM filesystem—see [66 scandir](66-scandir.html).

- **-s** *skel*: an absolute path; directory of the skeleton file `rc.init`. Default is `%%skel%%`.

- **-g** *gracetime*: specify a grace time between the `SIGTERM` and the `SIGKILL` in milliseconds if the shutdown command does not provide one. Defaults to `3000`.

- **-B**: inform the shutdown daemon that it is running in a container. This changes the nature of *stage 4*, since exiting a container is slightly different from rebooting a real machine (in particular, pid 1 has to exit, and great care must be given not to leave any zombie hanging around).

- **-c**: inform the shutdown daemon that no catch-all logger is running. This also changes the shutdown procedure slightly, since some operations are specific to the existence of a catch-all logger.

## Note

The *66-shutdownd* binary is not meant to be called directly. It is automatically generated by a [66 scandir](66-scandir.html) program invocation.
