.TH "ZIP_FILE_EXTRA_FIELD_GET" "3" "October 8, 2014" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_extra_field_get\fP,
\fBzip_file_extra_field_get_by_id\fP
\- get extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
const zip_uint8_t *
zip_file_extra_field_get zip_t *archive zip_uint64_t index zip_uint16_t extra_field_index zip_uint16_t *idp zip_uint16_t *lenp zip_flags_t flags
const zip_uint8_t *
zip_file_extra_field_get_by_id zip_t *archive zip_uint64_t index zip_uint16_t extra_field_id zip_uint16_t extra_field_index zip_uint16_t *lenp zip_flags_t flags
.SH "DESCRIPTION"
The
zip_file_extra_field_get
function returns the extra field with index
\fIextra_field_index\fP
for the file at position
\fIindex\fP
in the zip archive.
This pointer should not be modified or
free(3)'d,
and becomes invalid when
\fIarchive\fP
is closed.
If
\fIidp\fP
is not
\fRNULL\fP,
the integer to which it points will be set to the ID (two-byte
signature) of the selected extra field.
If
\fIlenp\fP
is not
\fRNULL\fP,
the integer to which it points will be set to the length of the
extra field.
Generally speaking,
\fIlenp\fP
and
\fIidp\fP
should be passed since only the extra field data is returned (i.e.,
neither the ID nor the length, if the
\fIidp\fP
and
\fIlenp\fP
arguments are not provided).
.PP
The following
\fIflags\fP
are supported:
.TP ZIP_FL_UNCHANGEDXX
\fRZIP_FL_CENTRAL\fP
Return extra fields from the archive's central directory.
.TP ZIP_FL_UNCHANGEDXX
\fRZIP_FL_LOCAL\fP
Return extra fields from the local file headers.
.TP ZIP_FL_UNCHANGEDXX
\fRZIP_FL_UNCHANGED\fP
Return the original unchanged extra fields, ignoring any changes made.
.PP
The
zip_file_extra_field_get_by_id
function returns the extra field with ID (two-byte signature)
\fIextra_field_id\fP
and index
\fIextra_field_index\fP
(in other words, the
\fIextra_field_index\fP'th
extra field with ID
\fIextra_field_id\fP)
The other arguments are the same as for
zip_file_extra_field_get.
.SH "RETURN VALUES"
Upon successful completion, a pointer to an extra field is returned,
or
\fRNULL\fP
if there is no extra field with that
\fIextra_field_index\fP
for the file with index
\fIindex\fP.
In case of an error,
\fRNULL\fP
is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_file_extra_field_get
and
zip_file_extra_field_get_by_id
fail if:
.TP 17n
[\fRZIP_ER_NOENT\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP,
or
\fIextra_field_index\fP
is not a valid extra file index (for ID
\fIextra_field_id\fP).
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_delete(3),
zip_file_extra_field_set(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
.SH "CAVEATS"
Please note that the extra field IDs 0x0001 (ZIP64 extension),
0x6375 (Infozip UTF-8 comment), and
0x7075 (Infozip UTF-8 file name) can not be read using
zip_file_extra_field_get
since they are used by
libzip(3)
internally.
