.TH "ZIP_FILE_SET_COMMENT" "3" "September 19, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_set_comment\fP
\- set comment for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
int
zip_set_file_comment zip_t *archive zip_uint64_t index const char *comment zip_uint16_t len zip_flags_t flags
.SH "DESCRIPTION"
The
zip_file_set_comment
function sets the comment for the file at position
\fIindex\fP
in the zip archive to
\fIcomment\fP
of length
\fIlen\fP.
If
\fIcomment\fP
is
\fRNULL\fP
and
\fIlen\fP
is 0, the file comment will be removed.
The
\fIflags\fP
argument can be any of:
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_GUESS\fP
Guess encoding of
\fIcomment\fP
(default).
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_UTF_8\fP
Interpret
\fIcomment\fP
as UTF-8.
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_CP437\fP
Interpret
\fIcomment\fP
as code page 437 (CP-437).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_file_set_comment
fails if:
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP,
or
\fIlen\fP
is less than 0 or longer than the maximum comment length in a zip file
(65535), or
\fIcomment\fP
is not a valid UTF-8 encoded string.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.TP 17n
[\fRZIP_ER_RDONLY\fP]
The
\fIarchive\fP
was opened in read-only mode.
.SH "SEE ALSO"
libzip(3),
zip_file_get_comment(3),
zip_get_archive_comment(3),
zip_set_archive_comment(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
