.TH "ZIP_NAME_LOCATE" "3" "July 21, 2012" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_name_locate\fP
\- get index of file by name
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
zip_int64_t
zip_name_locate zip_t *archive const char *fname zip_flags_t flags
.SH "DESCRIPTION"
The
zip_name_locate
function returns the index of the file named
\fIfname\fP
in
\fIarchive\fP.
If
\fIarchive\fP
does not contain a file with that name, \-1 is returned.
The
flags
are specified by
\fIor\fP'ing
the following values, or 0 for none of them.
.TP ZIP_FL_NOCASE
\fRZIP_FL_NOCASE\fP
Ignore case distinctions.
(Will only work well if the file names are ASCII.)
.TP ZIP_FL_NOCASE
\fRZIP_FL_NODIR\fP
Ignore directory part of file name in archive.
.TP ZIP_FL_NOCASE
\fRZIP_FL_ENC_RAW\fP
Compare against the unmodified names as it is in the ZIP archive.
.TP ZIP_FL_NOCASE
\fRZIP_FL_ENC_GUESS\fP
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary, before comparing.
.TP ZIP_FL_NOCASE
\fRZIP_FL_ENC_STRICT\fP
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8 before comparing.
\fINote\fP:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
zip_name_locate
returns the index of the file named
\fIfname\fP
or \-1, if
\fIarchive\fP
does not contain an entry of that name.
.SH "ERRORS"
zip_name_locate
fails if:
.TP 17n
[\fRZIP_ER_NOENT\fP]
No entry of the name
\fIfname\fP
is found in the archive.
.TP 17n
[\fRZIP_ER_INVAL\fP]
One of the arguments is invalid.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_get_name(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
