/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsaencrypt_bb3072_vectors_h__
#define rsaencrypt_bb3072_vectors_h__

#include "testvectors_base/test-structs.h"

/* 3072 bit key from Hubert's Bleichenbacher tests */
static const std::vector<uint8_t> kRsaBb3072{
    0x30, 0x82, 0x06, 0xfe, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
    0x06, 0xe8, 0x30, 0x82, 0x06, 0xe4, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
    0x81, 0x00, 0xaf, 0xd7, 0x1c, 0xaa, 0xd5, 0xe9, 0xf5, 0xb8, 0xc6, 0xc3,
    0x67, 0x07, 0x0a, 0x47, 0xf1, 0x9d, 0x7e, 0x66, 0xae, 0xde, 0x18, 0xa5,
    0xb2, 0x74, 0x1f, 0xb3, 0xc4, 0xd3, 0x34, 0x34, 0x56, 0x06, 0x92, 0xa2,
    0xd9, 0x09, 0xef, 0x68, 0x88, 0xec, 0x60, 0x2f, 0xf6, 0xb9, 0x3a, 0xf2,
    0x58, 0xee, 0x74, 0x30, 0x3c, 0x30, 0x1a, 0xfc, 0xd4, 0xed, 0xbe, 0xc4,
    0x33, 0x11, 0xdd, 0xc8, 0xdd, 0xbf, 0x00, 0xdd, 0xbb, 0xe3, 0x86, 0xd3,
    0x3b, 0x8d, 0x0e, 0x22, 0xb1, 0xb4, 0x49, 0x36, 0xdc, 0x48, 0x98, 0x71,
    0xb8, 0x52, 0x37, 0xb3, 0x4c, 0xe7, 0x47, 0xad, 0x8f, 0xdb, 0x0c, 0x4e,
    0x4d, 0x1d, 0xaa, 0x7a, 0xad, 0xf0, 0x73, 0x85, 0xc5, 0xc8, 0x73, 0x2c,
    0xcb, 0x7d, 0x5a, 0x49, 0xe2, 0xe5, 0x0c, 0x88, 0x3c, 0x7d, 0x7a, 0xc1,
    0x0e, 0xd6, 0xa7, 0x4d, 0x9a, 0xc9, 0x0d, 0xf9, 0x12, 0x99, 0x05, 0xa1,
    0x7d, 0x4a, 0x08, 0x72, 0x10, 0xfc, 0x78, 0xb6, 0xd0, 0x4b, 0x1e, 0xb9,
    0x69, 0x48, 0x2c, 0x11, 0xa6, 0xee, 0xb7, 0x9c, 0x50, 0xe5, 0xb1, 0x6f,
    0x3f, 0x25, 0x4f, 0x75, 0x71, 0x52, 0x8b, 0x2f, 0x17, 0x16, 0xab, 0x81,
    0x6d, 0x6e, 0xca, 0x07, 0x27, 0xbd, 0xea, 0x98, 0x05, 0x93, 0x29, 0x73,
    0x0e, 0xb8, 0xc3, 0x3c, 0xe7, 0x1d, 0x61, 0xdd, 0x4a, 0xc3, 0x93, 0xb6,
    0x25, 0x6e, 0x07, 0xac, 0x1d, 0x12, 0x4f, 0x02, 0x00, 0xd1, 0xc3, 0xe0,
    0x5a, 0x4c, 0x1b, 0xc7, 0xf1, 0xed, 0x2f, 0xc8, 0x3e, 0x57, 0x19, 0x9c,
    0xfe, 0x59, 0x08, 0xb1, 0x00, 0x87, 0xe2, 0x7f, 0xbd, 0x97, 0xd2, 0xc2,
    0x42, 0x14, 0x61, 0x9c, 0x71, 0x47, 0xc8, 0xfb, 0xef, 0xca, 0x39, 0xbc,
    0x25, 0x67, 0x62, 0xa6, 0x82, 0x35, 0x31, 0xf7, 0xe2, 0x34, 0xd6, 0x8e,
    0xae, 0x7a, 0x0d, 0x9f, 0xaf, 0x10, 0xdd, 0x15, 0xe9, 0x52, 0x37, 0x80,
    0xc7, 0xd5, 0xae, 0x58, 0x09, 0x4a, 0xd5, 0x25, 0xa9, 0x06, 0x3b, 0x4c,
    0x33, 0xf9, 0x5e, 0x10, 0x06, 0xda, 0x2e, 0xb1, 0x2d, 0x37, 0x43, 0x68,
    0x94, 0x95, 0xc1, 0xf2, 0x02, 0x3e, 0x40, 0x73, 0x53, 0xc5, 0xeb, 0x3e,
    0x4c, 0xa1, 0xc4, 0x8c, 0xff, 0x81, 0xa1, 0x09, 0x00, 0xd1, 0x48, 0x20,
    0xeb, 0x80, 0x1a, 0xf4, 0xf1, 0xa5, 0x96, 0xc4, 0xb9, 0xce, 0x9a, 0x53,
    0x1f, 0xcf, 0x8a, 0x54, 0xd9, 0xff, 0xd7, 0x24, 0x25, 0x8b, 0x6e, 0xec,
    0x20, 0x10, 0x8d, 0xf6, 0xfd, 0xfd, 0x76, 0xd4, 0xae, 0x03, 0xba, 0x7e,
    0xa5, 0x98, 0xdc, 0xb0, 0xe4, 0xa2, 0x80, 0x84, 0x95, 0x87, 0x28, 0x6f,
    0x4d, 0x7f, 0x25, 0x6c, 0xe8, 0x5e, 0x5e, 0xb5, 0x67, 0x9b, 0x1d, 0xac,
    0xc1, 0xf9, 0x09, 0x56, 0x49, 0xb7, 0x2e, 0x5f, 0xa0, 0x72, 0xae, 0xb0,
    0x03, 0x79, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02, 0x82, 0x01, 0x80, 0x25,
    0x17, 0xea, 0xcb, 0x3a, 0xfe, 0xf4, 0xbf, 0xfa, 0xe6, 0x03, 0x98, 0xdf,
    0x99, 0x57, 0xa5, 0xd2, 0xa1, 0x54, 0xa8, 0x33, 0x68, 0xd8, 0xe1, 0x58,
    0x42, 0xb2, 0xf5, 0x9e, 0xe0, 0x9f, 0x79, 0x19, 0x7b, 0xd2, 0xef, 0x1e,
    0x9a, 0xdd, 0xaf, 0x87, 0x86, 0xf6, 0xb4, 0x12, 0x74, 0x47, 0x40, 0x5e,
    0x30, 0x42, 0xb2, 0x1f, 0x2f, 0x50, 0xb7, 0xaa, 0x73, 0x77, 0x16, 0x80,
    0xc3, 0xbb, 0xcb, 0x6c, 0x22, 0x5a, 0x5d, 0x5f, 0xf6, 0xb5, 0x6c, 0x47,
    0x1c, 0x18, 0x82, 0xa0, 0xa3, 0x3b, 0x0a, 0xf1, 0x65, 0xa3, 0xed, 0x6c,
    0x24, 0x9d, 0xc7, 0x78, 0x3e, 0x6b, 0xc7, 0x58, 0xac, 0x37, 0xe6, 0x57,
    0x2d, 0x33, 0xfe, 0x32, 0x50, 0x78, 0xed, 0x95, 0x26, 0x50, 0xf2, 0xeb,
    0x96, 0x04, 0x90, 0x2e, 0xf9, 0x9a, 0x51, 0x1a, 0x11, 0x19, 0xd1, 0x3c,
    0x4f, 0xc9, 0xa4, 0x3a, 0x17, 0x5d, 0xcd, 0xfb, 0xfb, 0x1a, 0x14, 0x00,
    0xfe, 0x17, 0x09, 0x3b, 0x69, 0xcd, 0x3c, 0xdb, 0x89, 0x5f, 0x65, 0x43,
    0x2e, 0xa2, 0x19, 0x5f, 0x90, 0x51, 0x1c, 0x73, 0x36, 0xb5, 0x8a, 0x68,
    0x5d, 0xac, 0xff, 0x2d, 0xaf, 0x4c, 0x5e, 0x92, 0xe5, 0x65, 0xb1, 0x66,
    0x5a, 0xe6, 0x0e, 0x51, 0x2b, 0xaa, 0x99, 0x65, 0xb8, 0x08, 0xd5, 0xff,
    0x11, 0x9c, 0xeb, 0x7c, 0xd6, 0x92, 0xcb, 0xf9, 0x20, 0x06, 0x7a, 0xfa,
    0xcd, 0x80, 0x9f, 0x66, 0xbe, 0x70, 0x6d, 0xa2, 0x68, 0x10, 0xac, 0x79,
    0x0d, 0xb1, 0x56, 0xc9, 0x48, 0xe6, 0xfe, 0x58, 0x1b, 0xc9, 0x84, 0x91,
    0x57, 0xf4, 0xda, 0x49, 0x3f, 0x3a, 0x64, 0xb0, 0xc6, 0xe1, 0x19, 0xe0,
    0x31, 0xb1, 0x07, 0xf8, 0x43, 0x6c, 0xe2, 0x91, 0x60, 0xb4, 0x58, 0xb8,
    0xf9, 0xf1, 0x09, 0x5f, 0xde, 0xb1, 0x92, 0x63, 0x38, 0x4f, 0xf5, 0x38,
    0x75, 0x57, 0xbc, 0x4f, 0x10, 0xb4, 0x03, 0x4d, 0xe8, 0x41, 0x70, 0x3b,
    0xad, 0x2c, 0x1e, 0x76, 0x9c, 0x23, 0x85, 0x3e, 0xb6, 0x30, 0xa3, 0x6d,
    0x10, 0x61, 0xdd, 0x46, 0xe2, 0xa6, 0xbb, 0xaf, 0x74, 0x3a, 0x97, 0xf0,
    0xb3, 0x2c, 0x36, 0xf5, 0x0c, 0x1a, 0x37, 0x22, 0xde, 0xf3, 0xa3, 0x94,
    0xd9, 0x1c, 0x2e, 0x07, 0x8b, 0xf0, 0x9d, 0x79, 0x5e, 0xcd, 0xe5, 0xe5,
    0x6b, 0x82, 0x02, 0xf9, 0x74, 0x02, 0x6f, 0x75, 0xfc, 0x56, 0xe9, 0xa0,
    0xdd, 0x6a, 0x88, 0xf2, 0xe7, 0xcb, 0x78, 0xef, 0x12, 0x98, 0xcc, 0x6c,
    0x65, 0x20, 0x7c, 0xa4, 0x5b, 0xd3, 0x71, 0x88, 0x80, 0x7b, 0x4f, 0xcd,
    0xb1, 0xe6, 0x0d, 0xd8, 0xe5, 0xb8, 0x56, 0x48, 0xfb, 0x7e, 0xfa, 0x8b,
    0x6f, 0xdd, 0x44, 0x8f, 0x39, 0x74, 0x1a, 0x8d, 0x98, 0x09, 0xfe, 0x16,
    0x3a, 0xf3, 0xde, 0x45, 0xba, 0xc2, 0x4a, 0x5a, 0x84, 0x1c, 0x81, 0x02,
    0x81, 0xc1, 0x00, 0xe4, 0xa3, 0xd8, 0x30, 0xd7, 0x3e, 0x8b, 0x31, 0xc6,
    0x82, 0xe2, 0x74, 0xff, 0xc9, 0xfd, 0x12, 0xac, 0x31, 0x3d, 0x2d, 0xd0,
    0x51, 0x3d, 0x50, 0x57, 0x0d, 0xb7, 0xeb, 0x47, 0x62, 0xfe, 0xa1, 0x93,
    0xe7, 0xbb, 0x54, 0x0b, 0x94, 0xa9, 0x4a, 0x5d, 0xdd, 0x74, 0x2a, 0xcf,
    0x73, 0xf5, 0xde, 0xb9, 0xca, 0xe3, 0x1b, 0xd2, 0x3a, 0xc5, 0x60, 0xbb,
    0x27, 0x94, 0xfd, 0x68, 0x26, 0x1f, 0x82, 0x03, 0xf5, 0x71, 0x92, 0x82,
    0x90, 0x4f, 0x46, 0x1e, 0xac, 0xee, 0x2c, 0xe7, 0xe0, 0xa0, 0x09, 0x7a,
    0xa7, 0xc8, 0xdb, 0xab, 0xd3, 0x3f, 0x1b, 0xf2, 0x69, 0x91, 0x2a, 0x07,
    0x82, 0x71, 0x4f, 0xa9, 0x3b, 0x49, 0xea, 0xc4, 0x36, 0xeb, 0x3d, 0xe7,
    0x34, 0xa7, 0xd6, 0xff, 0xdf, 0xd8, 0xc2, 0xc1, 0x43, 0x5e, 0x84, 0x3f,
    0xc7, 0x09, 0xf9, 0x04, 0x8e, 0x54, 0x2a, 0x19, 0x7c, 0x48, 0x54, 0x2b,
    0xeb, 0x2b, 0x85, 0xea, 0xd0, 0xf5, 0xe6, 0x4a, 0xa6, 0x3d, 0x0e, 0xc0,
    0x15, 0x2b, 0x3f, 0x85, 0x61, 0x2d, 0xdc, 0xa6, 0xbf, 0xde, 0xab, 0xf3,
    0x17, 0x5d, 0x59, 0x7d, 0x40, 0x56, 0x3e, 0x0e, 0x06, 0x2d, 0x91, 0xcb,
    0x02, 0x88, 0x80, 0x08, 0x2f, 0xe9, 0xf8, 0xf0, 0x91, 0xbd, 0xbd, 0xda,
    0x31, 0x6e, 0xeb, 0x1e, 0x85, 0x8c, 0xa4, 0x4d, 0x2b, 0x02, 0x8a, 0xe9,
    0xcd, 0xe3, 0xa9, 0x02, 0x81, 0xc1, 0x00, 0xc4, 0xe1, 0xcd, 0x0e, 0xcf,
    0x42, 0x98, 0x61, 0x5e, 0x1f, 0x78, 0x9b, 0xa7, 0xde, 0x22, 0xfd, 0x50,
    0x94, 0xaf, 0x4a, 0xd1, 0xac, 0x29, 0x50, 0xee, 0x96, 0x30, 0x38, 0x5a,
    0x20, 0x40, 0x9a, 0x28, 0x0c, 0x65, 0x38, 0xa2, 0xfe, 0xed, 0x03, 0x14,
    0x48, 0xe2, 0x6e, 0x22, 0xd6, 0x70, 0x93, 0xa7, 0x1f, 0x9d, 0xc7, 0x4e,
    0xbd, 0x1a, 0xbc, 0x0e, 0x9c, 0xe8, 0x3d, 0x67, 0x0b, 0x02, 0x76, 0xab,
    0x1c, 0x85, 0xac, 0x73, 0x4d, 0xd8, 0xbf, 0x9c, 0x74, 0xcc, 0x7f, 0xec,
    0xbd, 0x73, 0x2d, 0x1d, 0x75, 0xf8, 0x89, 0xef, 0x46, 0x0a, 0x48, 0x19,
    0xba, 0x5e, 0x1b, 0x01, 0xde, 0x23, 0x32, 0x55, 0x51, 0x81, 0xb7, 0x6f,
    0xa9, 0x65, 0x44, 0x93, 0x19, 0x8a, 0x60, 0x6f, 0x00, 0xca, 0xfd, 0x8a,
    0x93, 0x35, 0x6e, 0x45, 0x6f, 0x22, 0x3b, 0x75, 0x1b, 0xd5, 0xb5, 0xca,
    0x97, 0xae, 0x2b, 0x39, 0xba, 0x77, 0xfb, 0x7c, 0x17, 0x4c, 0x82, 0xec,
    0x02, 0x18, 0x65, 0x60, 0xd5, 0xe2, 0x7b, 0xf1, 0x8a, 0x26, 0x3c, 0xc2,
    0x12, 0xd9, 0xcc, 0x66, 0xb0, 0x1d, 0x1d, 0xa2, 0x67, 0x3f, 0x29, 0x7d,
    0x4c, 0x1b, 0xed, 0x44, 0x5b, 0x4e, 0xfc, 0x5d, 0xb0, 0x61, 0x36, 0xec,
    0xaa, 0xbd, 0x82, 0xcb, 0x54, 0xd0, 0xfc, 0xc4, 0x26, 0x99, 0xd4, 0xd6,
    0x0a, 0x02, 0x27, 0xbf, 0xe0, 0x03, 0x51, 0x02, 0x81, 0xc0, 0x40, 0xf3,
    0x0e, 0x41, 0xe9, 0x93, 0x39, 0xc5, 0x5d, 0x07, 0xe7, 0x3e, 0xa7, 0x3f,
    0x00, 0xe6, 0x22, 0x06, 0x26, 0xc3, 0xf1, 0xee, 0x72, 0x05, 0x75, 0x85,
    0x4f, 0x1e, 0xc5, 0xfb, 0xa8, 0x2b, 0xcc, 0x31, 0x42, 0xf4, 0xc0, 0x09,
    0x6e, 0x01, 0xd3, 0x22, 0x4a, 0x92, 0xb2, 0xb5, 0xd5, 0x3d, 0x7c, 0xf7,
    0xd6, 0x86, 0x1b, 0xb5, 0x58, 0x46, 0x7f, 0x43, 0xe2, 0x3e, 0x0e, 0x2c,
    0xee, 0x3c, 0x67, 0xd5, 0x7c, 0x7a, 0xcb, 0x1e, 0x25, 0x76, 0xdc, 0xd5,
    0xf1, 0x1e, 0xce, 0x8b, 0xef, 0xca, 0x61, 0x8e, 0x72, 0x2f, 0x7c, 0xe3,
    0x18, 0x85, 0x5e, 0xda, 0x80, 0x43, 0x39, 0x38, 0xe3, 0xe9, 0x66, 0x40,
    0x92, 0x61, 0xdf, 0x75, 0x5e, 0x64, 0x0a, 0x5e, 0xd9, 0xe2, 0xe8, 0x72,
    0xf5, 0x47, 0x75, 0xd1, 0x26, 0x73, 0x59, 0x0e, 0xb8, 0x95, 0x85, 0xa6,
    0xcc, 0xdf, 0xdc, 0xb7, 0x82, 0x70, 0x6e, 0xbd, 0x72, 0x72, 0xab, 0x5e,
    0xca, 0xcb, 0xad, 0x9f, 0x05, 0xaf, 0x3f, 0xff, 0x83, 0x76, 0x9a, 0xf4,
    0x1d, 0x2c, 0x16, 0x2e, 0x61, 0x19, 0xe5, 0x87, 0x58, 0x9c, 0x48, 0x49,
    0x53, 0x76, 0x73, 0x53, 0x6b, 0xf4, 0x83, 0x7f, 0xe7, 0xb8, 0xbf, 0x1a,
    0xa5, 0x53, 0x73, 0x3b, 0x63, 0x74, 0x20, 0x1c, 0x74, 0xce, 0xd3, 0xaf,
    0xca, 0x61, 0x0e, 0x0e, 0xce, 0xbd, 0x19, 0x67, 0xc4, 0x69, 0x02, 0x81,
    0xc1, 0x00, 0xb9, 0x88, 0x4c, 0x14, 0x1b, 0xae, 0x97, 0x28, 0x92, 0x69,
    0x37, 0xdf, 0xff, 0x76, 0x6f, 0x24, 0xa6, 0x0e, 0x27, 0x8e, 0x6b, 0x3e,
    0x41, 0x05, 0x1a, 0x80, 0xff, 0xd9, 0xea, 0xdc, 0x9f, 0xe4, 0x65, 0xbf,
    0x20, 0x98, 0x19, 0xca, 0x00, 0x12, 0x39, 0xc8, 0x61, 0x51, 0x06, 0x95,
    0x6c, 0x2b, 0x48, 0x7f, 0x9b, 0xd0, 0xd9, 0x5b, 0x8d, 0x59, 0x10, 0xb0,
    0x3e, 0x8e, 0xb6, 0x8f, 0x02, 0x78, 0x4f, 0xd1, 0xa6, 0x0a, 0x97, 0xf2,
    0x11, 0x42, 0xa8, 0x2e, 0xcd, 0x13, 0xf4, 0x45, 0xa7, 0xc7, 0x29, 0x0f,
    0x25, 0xf2, 0xde, 0x3f, 0xf3, 0xaa, 0x74, 0x4c, 0x53, 0x28, 0x42, 0x3f,
    0x52, 0x8d, 0xb9, 0x27, 0x01, 0x05, 0x9b, 0x3d, 0x57, 0xc8, 0x22, 0x93,
    0x1b, 0xfa, 0xba, 0x40, 0x56, 0x0a, 0x4d, 0xcf, 0x61, 0xb7, 0x93, 0xc9,
    0x21, 0xca, 0x44, 0x16, 0xc1, 0xf2, 0xf9, 0x82, 0xac, 0xc7, 0xe1, 0x33,
    0xde, 0xa3, 0x68, 0x12, 0x10, 0xb1, 0x03, 0xb5, 0x09, 0xc6, 0x67, 0x55,
    0xc7, 0x83, 0xa3, 0x5f, 0xdb, 0x9e, 0xc0, 0x08, 0xc1, 0xa4, 0x44, 0x54,
    0xcc, 0x6b, 0x43, 0xc2, 0xe6, 0x1b, 0xb4, 0x0e, 0xc7, 0xf6, 0x74, 0xc7,
    0x53, 0x0c, 0xb1, 0x41, 0x68, 0xab, 0x38, 0xa5, 0xc1, 0xc7, 0x02, 0xd3,
    0xdf, 0xc9, 0x83, 0x13, 0x19, 0x3e, 0x1f, 0xa1, 0xf8, 0xdb, 0xfa, 0x8e,
    0x20, 0xb1, 0x02, 0x81, 0xc1, 0x00, 0xe1, 0x2a, 0x42, 0x01, 0x40, 0x7d,
    0x27, 0x51, 0xc9, 0xae, 0xb4, 0x2c, 0xb1, 0xf9, 0xe6, 0xaf, 0x34, 0xdc,
    0xd4, 0x45, 0x31, 0xa9, 0xae, 0x2a, 0x23, 0xdb, 0x54, 0x92, 0xf3, 0xc2,
    0x22, 0x9f, 0x6e, 0x33, 0xa2, 0x8a, 0x8a, 0x66, 0x40, 0xe4, 0xbf, 0x2f,
    0x1c, 0x6a, 0x23, 0x37, 0x8c, 0x5e, 0x56, 0x15, 0xe0, 0xeb, 0x12, 0xbf,
    0x14, 0xe8, 0x1b, 0xb9, 0x9c, 0x4c, 0xe1, 0x51, 0xb5, 0x4e, 0x61, 0x28,
    0x22, 0xbe, 0xb7, 0xca, 0x9e, 0x41, 0x0a, 0x5a, 0xfd, 0xdb, 0x0c, 0xa6,
    0x21, 0xe5, 0x97, 0x00, 0x2b, 0x9d, 0x1c, 0x81, 0x8c, 0x85, 0x60, 0x2f,
    0x99, 0x45, 0x29, 0x1a, 0x47, 0x50, 0x62, 0xec, 0x6a, 0xf5, 0x3f, 0x4f,
    0x52, 0x07, 0x9a, 0xd8, 0x1a, 0xc5, 0x9a, 0x37, 0xd9, 0xd5, 0xef, 0x70,
    0x08, 0x75, 0xfa, 0x77, 0x42, 0x1d, 0x50, 0x70, 0x6c, 0x74, 0xce, 0x17,
    0x87, 0x28, 0x9c, 0x0f, 0xa0, 0xf9, 0x4b, 0x29, 0xe1, 0xb6, 0x52, 0x49,
    0x69, 0xf9, 0x9d, 0x4e, 0x28, 0x22, 0x2c, 0xef, 0x49, 0x5a, 0x46, 0xed,
    0x21, 0x9e, 0xd0, 0x69, 0xe0, 0x77, 0x11, 0xfd, 0x52, 0xc7, 0x6a, 0x6e,
    0xfc, 0xdc, 0x8a, 0x9d, 0x44, 0x29, 0xe1, 0xd1, 0x4d, 0x9a, 0xc7, 0x20,
    0x46, 0x26, 0x07, 0xec, 0x74, 0x2d, 0xa4, 0x48, 0x07, 0x77, 0x70, 0x64,
    0xd8, 0x9d, 0x2b, 0x74, 0xe4, 0x2b};

const std::vector<RsaDecryptTestVector> kRsaBb3072Vectors = {
    // an invalid ciphertext that generates a synthethic plaintext
    // that's zero bytes in length
    {0,
     {},
     {0x5e, 0x95, 0x6c, 0xd9, 0x65, 0x2f, 0x4a, 0x2e, 0xce, 0x90, 0x29, 0x31,
      0x01, 0x3e, 0x09, 0x66, 0x2b, 0x6a, 0x92, 0x57, 0xad, 0x1e, 0x98, 0x7f,
      0xb7, 0x5f, 0x73, 0xa0, 0x60, 0x6d, 0xf2, 0xa4, 0xb0, 0x47, 0x89, 0x77,
      0x08, 0x20, 0xc2, 0xe0, 0x23, 0x22, 0xc4, 0xe8, 0x26, 0xf7, 0x67, 0xbd,
      0x89, 0x57, 0x34, 0xa0, 0x1e, 0x20, 0x60, 0x9c, 0x3b, 0xe4, 0x51, 0x7a,
      0x7a, 0x2a, 0x58, 0x9e, 0xa1, 0xcd, 0xc1, 0x37, 0xbe, 0xb7, 0x3e, 0xb3,
      0x8d, 0xac, 0x78, 0x1b, 0x52, 0xe8, 0x63, 0xde, 0x96, 0x20, 0xf7, 0x9f,
      0x9b, 0x90, 0xfd, 0x5b, 0x95, 0x36, 0x51, 0xfc, 0xbf, 0xef, 0x4a, 0x9f,
      0x1c, 0xc0, 0x74, 0x21, 0xd5, 0x11, 0xa8, 0x7d, 0xd6, 0x94, 0x2c, 0xaa,
      0xb6, 0xa5, 0xa0, 0xf4, 0xdf, 0x47, 0x3e, 0x62, 0xde, 0xfb, 0x52, 0x9a,
      0x7d, 0xe1, 0x50, 0x9a, 0xb9, 0x9c, 0x59, 0x6e, 0x1d, 0xff, 0x13, 0x20,
      0x40, 0x22, 0x98, 0xd8, 0xbe, 0x73, 0xa8, 0x96, 0xcc, 0x86, 0xc3, 0x8a,
      0xe3, 0xf2, 0xf5, 0x76, 0xe9, 0xea, 0x70, 0xcc, 0x28, 0xad, 0x57, 0x5c,
      0xb0, 0xf8, 0x54, 0xf0, 0xbe, 0x43, 0x18, 0x6b, 0xaa, 0x9c, 0x18, 0xe2,
      0x9c, 0x47, 0xc6, 0xca, 0x77, 0x13, 0x5d, 0xb7, 0x9c, 0x81, 0x12, 0x31,
      0xb7, 0xc1, 0x73, 0x09, 0x55, 0x88, 0x7d, 0x32, 0x1f, 0xdc, 0x06, 0x56,
      0x83, 0x82, 0xb8, 0x66, 0x43, 0xcf, 0x08, 0x9b, 0x10, 0xe3, 0x5a, 0xb2,
      0x3e, 0x82, 0x7d, 0x2e, 0x5a, 0xa7, 0xb4, 0xe9, 0x9f, 0xf2, 0xe9, 0x14,
      0xf3, 0x02, 0x35, 0x18, 0x19, 0xeb, 0x4d, 0x16, 0x93, 0x24, 0x3b, 0x35,
      0xf8, 0xbf, 0x1d, 0x42, 0xd0, 0x8f, 0x8e, 0xc4, 0xac, 0xaf, 0xa3, 0x5f,
      0x74, 0x7a, 0x4a, 0x97, 0x5a, 0x28, 0x64, 0x3e, 0xc6, 0x30, 0xd8, 0xe4,
      0xfa, 0x5b, 0xe5, 0x9d, 0x81, 0x99, 0x56, 0x60, 0xa1, 0x4b, 0xb6, 0x4c,
      0x1f, 0xea, 0x51, 0x46, 0xd6, 0xb1, 0x1f, 0x92, 0xda, 0x6a, 0x39, 0x56,
      0xdd, 0x5c, 0xb5, 0xe0, 0xd7, 0x47, 0xcf, 0x2e, 0xa2, 0x3f, 0x81, 0x61,
      0x77, 0x69, 0x18, 0x53, 0x36, 0x26, 0x3d, 0x46, 0xef, 0x4c, 0x14, 0x4b,
      0x75, 0x4d, 0xe6, 0x2a, 0x63, 0x37, 0x34, 0x2d, 0x6c, 0x85, 0xa9, 0x5f,
      0x19, 0xf0, 0x15, 0x72, 0x45, 0x46, 0xee, 0x3f, 0xc4, 0x82, 0x3e, 0xca,
      0x60, 0x3d, 0xbc, 0x1d, 0xc0, 0x1c, 0x2d, 0x5e, 0xd5, 0x0b, 0xd7, 0x2d,
      0x8e, 0x96, 0xdf, 0x2d, 0xc0, 0x48, 0xed, 0xde, 0x00, 0x81, 0x28, 0x40,
      0x68, 0x28, 0x3f, 0xc5, 0xe7, 0x3a, 0x61, 0x39, 0x85, 0x1a, 0xbf, 0x2f,
      0x29, 0x97, 0x7d, 0x0b, 0x3d, 0x16, 0x0c, 0x88, 0x3a, 0x42, 0xa3, 0x7e,
      0xfb, 0xa1, 0xbe, 0x05, 0xc1, 0xa0, 0xb1, 0x74, 0x1d, 0x7d, 0xdf, 0x59},
     {},
     false,
     true},

    // an invalid ciphertext that generates last length that's one byte
    // too long for the key size, so the second to last value needs to get
    // used
    {0,
     {0x56, 0xa3, 0xbe, 0xa0, 0x54, 0xe0, 0x13, 0x38, 0xbe, 0x9b, 0x7d, 0x79,
      0x57, 0x53, 0x9c},
     {0x7d, 0xb0, 0x39, 0x0d, 0x75, 0xfc, 0xf9, 0xd4, 0xc5, 0x9c, 0xf2, 0x7b,
      0x26, 0x41, 0x90, 0xd8, 0x56, 0xda, 0x9a, 0xbd, 0x11, 0xe9, 0x23, 0x34,
      0xd0, 0xe5, 0xf7, 0x10, 0x05, 0xcf, 0xed, 0x86, 0x5a, 0x71, 0x1d, 0xfa,
      0x28, 0xb7, 0x91, 0x18, 0x83, 0x74, 0xb6, 0x19, 0x16, 0xdb, 0xc1, 0x13,
      0x39, 0xbf, 0x14, 0xb0, 0x6f, 0x5f, 0x3f, 0x68, 0xc2, 0x06, 0xc5, 0x60,
      0x73, 0x80, 0xe1, 0x3d, 0xa3, 0x12, 0x9b, 0xfb, 0x74, 0x41, 0x57, 0xe1,
      0x52, 0x7d, 0xd6, 0xfd, 0xf6, 0x65, 0x12, 0x48, 0xb0, 0x28, 0xa4, 0x96,
      0xae, 0x1b, 0x97, 0x70, 0x2d, 0x44, 0x70, 0x60, 0x43, 0xcd, 0xaa, 0x7a,
      0x59, 0xc0, 0xf4, 0x13, 0x67, 0x30, 0x3f, 0x21, 0xf2, 0x68, 0x96, 0x8b,
      0xf3, 0xbd, 0x29, 0x04, 0xdb, 0x3a, 0xe5, 0x23, 0x9b, 0x55, 0xf8, 0xb4,
      0x38, 0xd9, 0x3d, 0x7d, 0xb9, 0xd1, 0x66, 0x6c, 0x07, 0x1c, 0x08, 0x57,
      0xe2, 0xec, 0x37, 0x75, 0x74, 0x63, 0x76, 0x9c, 0x54, 0xe5, 0x1f, 0x05,
      0x2b, 0x2a, 0x71, 0xb0, 0x4c, 0x28, 0x69, 0xe9, 0xe7, 0x04, 0x9a, 0x10,
      0x37, 0xb8, 0x42, 0x92, 0x06, 0xc9, 0x97, 0x26, 0xf0, 0x72, 0x89, 0xba,
      0xc1, 0x83, 0x63, 0xe7, 0xeb, 0x2a, 0x5b, 0x41, 0x7f, 0x47, 0xc3, 0x7a,
      0x55, 0x09, 0x0c, 0xda, 0x67, 0x65, 0x17, 0xb3, 0x54, 0x9c, 0x87, 0x3f,
      0x2f, 0xe9, 0x5d, 0xa9, 0x68, 0x17, 0x52, 0xec, 0x98, 0x64, 0xb0, 0x69,
      0x08, 0x9a, 0x2e, 0xd2, 0xf3, 0x40, 0xc8, 0xb0, 0x4e, 0xe0, 0x00, 0x79,
      0x05, 0x5a, 0x81, 0x7a, 0x33, 0x55, 0xb4, 0x6a, 0xc7, 0xdc, 0x00, 0xd1,
      0x7f, 0x45, 0x04, 0xcc, 0xfb, 0xcf, 0xca, 0xdb, 0x0c, 0x04, 0xcb, 0x6b,
      0x22, 0x06, 0x9e, 0x17, 0x93, 0x85, 0xae, 0x1e, 0xaf, 0xab, 0xad, 0x55,
      0x21, 0xba, 0xc2, 0xb8, 0xa8, 0xee, 0x1d, 0xff, 0xf5, 0x9a, 0x22, 0xeb,
      0x3f, 0xda, 0xcf, 0xc8, 0x71, 0x75, 0xd1, 0x0d, 0x78, 0x94, 0xcf, 0xd8,
      0x69, 0xd0, 0x56, 0x05, 0x7d, 0xd9, 0x94, 0x4b, 0x86, 0x9c, 0x17, 0x84,
      0xfc, 0xc2, 0x7f, 0x73, 0x1b, 0xc4, 0x61, 0x71, 0xd3, 0x95, 0x70, 0xfb,
      0xff, 0xba, 0xdf, 0x08, 0x2d, 0x33, 0xf6, 0x35, 0x2e, 0xcf, 0x44, 0xac,
      0xa8, 0xd9, 0x47, 0x8e, 0x53, 0xf5, 0xa5, 0xb7, 0xc8, 0x52, 0xb4, 0x01,
      0xe8, 0xf5, 0xf7, 0x4d, 0xa4, 0x9d, 0xa9, 0x1e, 0x65, 0xbd, 0xc9, 0x77,
      0x65, 0xa9, 0x52, 0x3b, 0x7a, 0x08, 0x85, 0xa6, 0xf8, 0xaf, 0xe5, 0x75,
      0x9d, 0x58, 0x00, 0x9f, 0xbf, 0xa8, 0x37, 0x47, 0x2a, 0x96, 0x8e, 0x6a,
      0xe9, 0x20, 0x26, 0xa5, 0xe0, 0x20, 0x2a, 0x39, 0x54, 0x83, 0x09, 0x53,
      0x02, 0xd6, 0xc3, 0x98, 0x5b, 0x5f, 0x58, 0x31, 0xc5, 0x21, 0xa2, 0x71},
     {},
     false,
     true},

    // an invalid ciphertext that generates a plaintext of maximum size
    // for this key size
    {0,
     {0x7b, 0x03, 0x6f, 0xcd, 0x62, 0x43, 0x90, 0x0e, 0x42, 0x36, 0xc8, 0x94,
      0xe2, 0x46, 0x2c, 0x17, 0x73, 0x8a, 0xcc, 0x87, 0xe0, 0x1a, 0x76, 0xf4,
      0xd9, 0x5c, 0xb9, 0xa3, 0x28, 0xd9, 0xac, 0xde, 0x81, 0x65, 0x02, 0x83,
      0xb8, 0xe8, 0xf6, 0x0a, 0x21, 0x7e, 0x3b, 0xde, 0xe8, 0x35, 0xc7, 0xb2,
      0x22, 0xad, 0x4c, 0x85, 0xd0, 0xac, 0xdb, 0x9a, 0x30, 0x9b, 0xd2, 0xa7,
      0x54, 0x60, 0x9a, 0x65, 0xde, 0xc5, 0x0f, 0x3a, 0xa0, 0x4c, 0x6d, 0x58,
      0x91, 0x03, 0x45, 0x66, 0xb9, 0x56, 0x3d, 0x42, 0x66, 0x8e, 0xde, 0x1f,
      0x89, 0x92, 0xb1, 0x77, 0x53, 0xa2, 0x13, 0x2e, 0x28, 0x97, 0x05, 0x84,
      0xe2, 0x55, 0xef, 0xc8, 0xb4, 0x5a, 0x41, 0xc5, 0xdb, 0xd7, 0x56, 0x7f,
      0x01, 0x4a, 0xce, 0xc5, 0xfe, 0x6f, 0xdb, 0x6d, 0x48, 0x47, 0x90, 0x36,
      0x0a, 0x91, 0x3e, 0xbb, 0x9d, 0xef, 0xcd, 0x74, 0xff, 0x37, 0x7f, 0x2a,
      0x8b, 0xa4, 0x6d, 0x2e, 0xd8, 0x5f, 0x73, 0x3c, 0x9a, 0x3d, 0xa0, 0x8e,
      0xb5, 0x7e, 0xce, 0xdf, 0xaf, 0xda, 0x80, 0x67, 0x78, 0xf0, 0x3c, 0x66,
      0xb2, 0xc5, 0xd2, 0x87, 0x4c, 0xec, 0x1c, 0x29, 0x1b, 0x2d, 0x49, 0xeb,
      0x19, 0x4c, 0x7b, 0x5d, 0x0d, 0xd2, 0x90, 0x8a, 0xe9, 0x0f, 0x48, 0x43,
      0x26, 0x8a, 0x2c, 0x45, 0x56, 0x30, 0x92, 0xad, 0xe0, 0x8a, 0xcb, 0x6a,
      0xb4, 0x81, 0xa0, 0x81, 0x76, 0x10, 0x2f, 0xc8, 0x03, 0xfb, 0xb2, 0xf8,
      0xad, 0x11, 0xb0, 0xe1, 0x53, 0x1b, 0xd3, 0x7d, 0xf5, 0x43, 0x49, 0x8d,
      0xaf, 0x18, 0x0b, 0x12, 0x01, 0x7f, 0x4d, 0x4d, 0x42, 0x6c, 0xa2, 0x9b,
      0x41, 0x61, 0x07, 0x55, 0x34, 0xbf, 0xb9, 0x14, 0x96, 0x80, 0x88, 0xa9,
      0xd1, 0x37, 0x85, 0xd0, 0xad, 0xc0, 0xe2, 0x58, 0x0d, 0x35, 0x48, 0x49,
      0x4b, 0x2a, 0x9e, 0x91, 0x60, 0x5f, 0x2b, 0x27, 0xe6, 0xcc, 0x70, 0x1c,
      0x79, 0x6f, 0x0d, 0xe7, 0xc6, 0xf4, 0x71, 0xf6, 0xab, 0x6c, 0xb9, 0x27,
      0x2a, 0x1e, 0xd6, 0x37, 0xca, 0x32, 0xa6, 0x0d, 0x11, 0x75, 0x05, 0xd8,
      0x2a, 0xf3, 0xc1, 0x33, 0x61, 0x04, 0xaf, 0xb5, 0x37, 0xd0, 0x1a, 0x8f,
      0x70, 0xb5, 0x10, 0xe1, 0xee, 0xbf, 0x48, 0x69, 0xcb, 0x97, 0x6c, 0x41,
      0x94, 0x73, 0x79, 0x5a, 0x66, 0xc7, 0xf5, 0xe6, 0xe2, 0x0a, 0x80, 0x94,
      0xb1, 0xbb, 0x60, 0x3a, 0x74, 0x33, 0x0c, 0x53, 0x7c, 0x5c, 0x06, 0x98,
      0xc3, 0x15, 0x38, 0xbd, 0x2e, 0x13, 0x8c, 0x12, 0x75, 0xa1, 0xbd, 0xf2,
      0x4c, 0x5f, 0xa8, 0xab, 0x3b, 0x7b, 0x52, 0x63, 0x24, 0xe7, 0x91, 0x8a,
      0x38, 0x2d, 0x13, 0x63, 0xb3, 0xd4, 0x63, 0x76, 0x42, 0x22, 0x15, 0x0e,
      0x04},
     {0x17, 0x15, 0x06, 0x53, 0x22, 0x52, 0x2d, 0xff, 0x85, 0x04, 0x98, 0x00,
      0xf6, 0xa2, 0x9a, 0xb5, 0xf9, 0x8c, 0x46, 0x50, 0x20, 0x46, 0x74, 0x14,
      0xb2, 0xa4, 0x41, 0x27, 0xfe, 0x94, 0x46, 0xda, 0x47, 0xfa, 0x18, 0x04,
      0x79, 0x00, 0xf9, 0x9a, 0xfe, 0x67, 0xc2, 0xdf, 0x6f, 0x50, 0x16, 0x0b,
      0xb8, 0xe9, 0x0b, 0xff, 0x29, 0x66, 0x10, 0xfd, 0xe6, 0x32, 0xb3, 0x85,
      0x9d, 0x4d, 0x0d, 0x2e, 0x64, 0x4f, 0x23, 0x83, 0x50, 0x28, 0xc4, 0x6c,
      0xca, 0x01, 0xb8, 0x4b, 0x88, 0x23, 0x1d, 0x7e, 0x03, 0x15, 0x4e, 0xde,
      0xc6, 0x62, 0x7b, 0xcb, 0xa2, 0x3d, 0xe7, 0x67, 0x40, 0xd8, 0x39, 0x85,
      0x1f, 0xa1, 0x2d, 0x74, 0xc8, 0xf9, 0x2e, 0x54, 0x0c, 0x73, 0xfe, 0x83,
      0x7b, 0x91, 0xb7, 0xd6, 0x99, 0xb3, 0x11, 0x99, 0x7d, 0x5f, 0x0f, 0x78,
      0x64, 0xc4, 0x86, 0xd4, 0x99, 0xc3, 0xa7, 0x9c, 0x11, 0x1f, 0xaa, 0xac,
      0xbe, 0x47, 0x99, 0x59, 0x7a, 0x25, 0x06, 0x6c, 0x62, 0x00, 0x21, 0x5c,
      0x3d, 0x15, 0x8f, 0x38, 0x17, 0xc1, 0xaa, 0x57, 0xf1, 0x8b, 0xda, 0xad,
      0x0b, 0xe1, 0x65, 0x8d, 0xa9, 0xda, 0x93, 0xf5, 0xcc, 0x6c, 0x3c, 0x4d,
      0xd7, 0x27, 0x88, 0xaf, 0x57, 0xad, 0xbb, 0x6a, 0x0c, 0x26, 0xf4, 0x2d,
      0x32, 0xd9, 0x5b, 0x8a, 0x4f, 0x95, 0xe8, 0xc6, 0xfe, 0xb2, 0xf8, 0xa5,
      0xd5, 0x3b, 0x19, 0xa5, 0x0a, 0x0b, 0x7c, 0xbc, 0x25, 0xe0, 0x55, 0xad,
      0x03, 0xe5, 0xac, 0xe8, 0xf3, 0xf7, 0xdb, 0x13, 0xe5, 0x77, 0x59, 0xf6,
      0x7b, 0x65, 0xd1, 0x43, 0xf0, 0x8c, 0xca, 0x15, 0x99, 0x2c, 0x6b, 0x2a,
      0xae, 0x64, 0x33, 0x90, 0x48, 0x3d, 0xe1, 0x11, 0xc2, 0x98, 0x8d, 0x4e,
      0x76, 0xb4, 0x25, 0x96, 0x26, 0x60, 0x05, 0x10, 0x3c, 0x8d, 0xe6, 0x04,
      0x4f, 0xb7, 0x39, 0x8e, 0xb3, 0xc2, 0x8a, 0x86, 0x4f, 0xa6, 0x72, 0xde,
      0x5f, 0xd8, 0x77, 0x45, 0x10, 0xff, 0x45, 0xe0, 0x59, 0x69, 0xa1, 0x1a,
      0x4c, 0x7d, 0x3f, 0x34, 0x3e, 0x33, 0x11, 0x90, 0xd2, 0xdc, 0xf2, 0x4f,
      0xb9, 0x15, 0x4b, 0xa9, 0x04, 0xdc, 0x94, 0xaf, 0x98, 0xaf, 0xc5, 0x77,
      0x4a, 0x96, 0x17, 0xd0, 0x41, 0x8f, 0xe6, 0xd1, 0x3f, 0x82, 0x45, 0xc7,
      0xd7, 0x62, 0x6c, 0x17, 0x61, 0x38, 0xdd, 0x69, 0x8a, 0x23, 0x54, 0x7c,
      0x25, 0xf2, 0x7c, 0x2b, 0x98, 0xea, 0x4d, 0x8a, 0x45, 0xc7, 0x84, 0x2b,
      0x81, 0x88, 0x8e, 0x4c, 0xc1, 0x4e, 0x5b, 0x72, 0xe9, 0xcf, 0x91, 0xf5,
      0x69, 0x56, 0xc9, 0x3d, 0xbf, 0x2e, 0x5f, 0x44, 0xa8, 0x28, 0x2a, 0x78,
      0x13, 0x15, 0x7f, 0xc4, 0x81, 0xff, 0x13, 0x71, 0xa0, 0xf6, 0x6b, 0x31,
      0x79, 0x7e, 0x81, 0xeb, 0xdb, 0x09, 0xa6, 0x73, 0xd4, 0xdb, 0x96, 0xd6},
     {},
     false,
     true},

    // test_positive_9_bytes_long
    {0,
     // 'forty two'
     {0x66, 0x6f, 0x72, 0x74, 0x79, 0x20, 0x74, 0x77, 0x6f},
     {0x6c, 0x60, 0x84, 0x5a, 0x85, 0x4b, 0x45, 0x71, 0xf6, 0x78, 0x94, 0x1a,
      0xe3, 0x5a, 0x2a, 0xc0, 0x3f, 0x67, 0xc2, 0x1e, 0x21, 0x14, 0x6f, 0x9d,
      0xb1, 0xf2, 0x30, 0x6b, 0xe9, 0xf1, 0x36, 0x45, 0x3b, 0x86, 0xad, 0x55,
      0x64, 0x7d, 0x4f, 0x7b, 0x5c, 0x9e, 0x62, 0x19, 0x7a, 0xaf, 0xf0, 0xc0,
      0xe4, 0x0a, 0x3b, 0x54, 0xc4, 0xcd, 0xe1, 0x4e, 0x77, 0x4b, 0x1c, 0x59,
      0x59, 0xb6, 0xc2, 0xa2, 0x30, 0x28, 0x96, 0xff, 0xae, 0x1f, 0x73, 0xb0,
      0x0b, 0x86, 0x2a, 0x20, 0xff, 0x43, 0x04, 0xfe, 0x06, 0xce, 0xa7, 0xff,
      0x30, 0xec, 0xb3, 0x77, 0x3c, 0xa9, 0xaf, 0x27, 0xa0, 0xb5, 0x45, 0x47,
      0x35, 0x0d, 0x7c, 0x07, 0xdf, 0xb0, 0xa3, 0x96, 0x29, 0xc7, 0xe7, 0x1e,
      0x83, 0xfc, 0x5a, 0xf9, 0xb2, 0xad, 0xba, 0xf8, 0x98, 0xe0, 0x37, 0xf1,
      0xde, 0x69, 0x6a, 0x3f, 0x32, 0x8c, 0xf4, 0x5a, 0xf7, 0xec, 0x9a, 0xff,
      0x71, 0x73, 0x85, 0x40, 0x87, 0xfb, 0x8f, 0xbf, 0x34, 0xbe, 0x98, 0x1e,
      0xfb, 0xd8, 0x49, 0x3f, 0x94, 0x38, 0xd1, 0xb2, 0xba, 0x2a, 0x86, 0xaf,
      0x08, 0x26, 0x62, 0xaa, 0x46, 0xae, 0x9a, 0xdf, 0xbe, 0xc5, 0x1e, 0x5f,
      0x3d, 0x95, 0x50, 0xa4, 0xdd, 0x1d, 0xcb, 0x7c, 0x89, 0x69, 0xc9, 0x58,
      0x7a, 0x6e, 0xdc, 0x82, 0xa8, 0xca, 0xbb, 0xc7, 0x85, 0xc4, 0x0d, 0x9f,
      0xbd, 0x12, 0x06, 0x45, 0x59, 0xfb, 0x76, 0x94, 0x50, 0xac, 0x3e, 0x47,
      0xe8, 0x7b, 0xc0, 0x46, 0x14, 0x81, 0x30, 0xd7, 0xea, 0xa8, 0x43, 0xe4,
      0xb3, 0xcc, 0xef, 0x36, 0x75, 0xd0, 0x63, 0x05, 0x00, 0x80, 0x3c, 0xb7,
      0xff, 0xee, 0x38, 0x82, 0x37, 0x8c, 0x1a, 0x40, 0x4e, 0x85, 0x0c, 0x3e,
      0x20, 0x70, 0x7b, 0xb7, 0x45, 0xe4, 0x2b, 0x13, 0xc1, 0x87, 0x86, 0xc4,
      0x97, 0x60, 0x76, 0xed, 0x9f, 0xa8, 0xfd, 0x0f, 0xf1, 0x5e, 0x57, 0x1b,
      0xef, 0x02, 0xcb, 0xbe, 0x2f, 0x90, 0xc9, 0x08, 0xac, 0x37, 0x34, 0xa4,
      0x33, 0xb7, 0x3e, 0x77, 0x8d, 0x4d, 0x17, 0xfc, 0xc2, 0x8f, 0x49, 0x18,
      0x5e, 0xbc, 0x6e, 0x85, 0x36, 0xa0, 0x6d, 0x29, 0x32, 0x02, 0xd9, 0x44,
      0x96, 0x45, 0x3b, 0xfd, 0xf1, 0xc2, 0xc7, 0x83, 0x3a, 0x3f, 0x99, 0xfa,
      0x38, 0xca, 0x8a, 0x81, 0xf4, 0x2e, 0xaa, 0x52, 0x9d, 0x60, 0x3b, 0x89,
      0x03, 0x08, 0xa3, 0x19, 0xc0, 0xab, 0x63, 0xa3, 0x5f, 0xf8, 0xeb, 0xac,
      0x96, 0x5f, 0x62, 0x78, 0xf5, 0xa7, 0xe5, 0xd6, 0x22, 0xbe, 0x5d, 0x5f,
      0xe5, 0x5f, 0x0c, 0xa3, 0xec, 0x99, 0x3d, 0x55, 0x43, 0x0d, 0x2b, 0xf5,
      0x9c, 0x5d, 0x3e, 0x86, 0x0e, 0x90, 0xc1, 0x6d, 0x91, 0xa0, 0x45, 0x96,
      0xf6, 0xfd, 0xf6, 0x0d, 0x89, 0xed, 0x95, 0xd8, 0x8c, 0x03, 0x6d, 0xde},
     {},
     false,
     true},

    // a valid ciphertext that starts with a null byte and decrypts to
    // 9 byte long value
    {0,
     // 'forty two'
     {0x66, 0x6f, 0x72, 0x74, 0x79, 0x20, 0x74, 0x77, 0x6f},
     {0x00, 0xf4, 0xd5, 0x65, 0xa3, 0x28, 0x67, 0x84, 0xdb, 0xb8, 0x53, 0x27,
      0xdb, 0x88, 0x07, 0xae, 0x55, 0x7e, 0xad, 0x22, 0x9f, 0x92, 0xab, 0xa9,
      0x45, 0xce, 0xcd, 0xa5, 0x22, 0x5f, 0x60, 0x6a, 0x7d, 0x61, 0x30, 0xed,
      0xee, 0xb6, 0xf2, 0x67, 0x24, 0xd1, 0xef, 0xf1, 0x11, 0x0f, 0x9e, 0xb1,
      0x8d, 0xc3, 0x24, 0x81, 0x40, 0xee, 0x38, 0x37, 0xe6, 0x68, 0x83, 0x91,
      0xe7, 0x87, 0x96, 0xc5, 0x26, 0x79, 0x13, 0x84, 0xf0, 0x45, 0xe2, 0x1b,
      0x6b, 0x85, 0x3f, 0xb6, 0x34, 0x2a, 0x11, 0xf3, 0x09, 0xeb, 0x77, 0x96,
      0x2f, 0x37, 0xce, 0x23, 0x92, 0x5a, 0xf6, 0x00, 0x84, 0x7f, 0xbd, 0x30,
      0xe6, 0xe0, 0x7e, 0x57, 0xde, 0x50, 0xb6, 0x06, 0xe6, 0xb7, 0xf2, 0x88,
      0xcc, 0x77, 0x7c, 0x1a, 0x68, 0x34, 0xf2, 0x7e, 0x6e, 0xda, 0xce, 0x50,
      0x84, 0x52, 0x12, 0x89, 0x16, 0xee, 0xf7, 0x78, 0x8c, 0x8b, 0xb2, 0x27,
      0xe3, 0x54, 0x8c, 0x6a, 0x76, 0x1c, 0xc4, 0xe9, 0xdd, 0x1a, 0x35, 0x84,
      0x17, 0x6d, 0xc0, 0x53, 0xba, 0x35, 0x00, 0xad, 0xb1, 0xd5, 0xe1, 0x61,
      0x12, 0x91, 0x65, 0x4f, 0x12, 0xdf, 0xc5, 0x72, 0x28, 0x32, 0xf6, 0x35,
      0xdb, 0x30, 0x02, 0xd7, 0x3f, 0x9d, 0xef, 0xc3, 0x10, 0xac, 0xe6, 0x2c,
      0x63, 0x86, 0x8d, 0x34, 0x16, 0x19, 0xc7, 0xee, 0x15, 0xb2, 0x02, 0x43,
      0xb3, 0x37, 0x1e, 0x05, 0x07, 0x8e, 0x11, 0x21, 0x97, 0x70, 0xc7, 0x01,
      0xd9, 0xf3, 0x41, 0xaf, 0x35, 0xdf, 0x1b, 0xc7, 0x29, 0xde, 0x29, 0x48,
      0x25, 0xff, 0x2e, 0x41, 0x6a, 0xa1, 0x15, 0x26, 0x61, 0x28, 0x52, 0x77,
      0x7e, 0xb1, 0x31, 0xf9, 0xc4, 0x51, 0x51, 0xeb, 0x14, 0x49, 0x80, 0xd7,
      0x06, 0x08, 0xd2, 0xfc, 0x40, 0x43, 0x47, 0x73, 0x68, 0x36, 0x9a, 0xa0,
      0xfe, 0x48, 0x7a, 0x48, 0xbd, 0x57, 0xe6, 0x6b, 0x00, 0xc3, 0xc5, 0x8f,
      0x94, 0x15, 0x49, 0xf5, 0xec, 0x05, 0x0f, 0xca, 0x64, 0x44, 0x9d, 0xeb,
      0xe7, 0xa0, 0xc4, 0xac, 0x51, 0xe5, 0x5c, 0xb7, 0x16, 0x20, 0xa7, 0x03,
      0x12, 0xaa, 0x4b, 0xd8, 0x5f, 0xac, 0x14, 0x10, 0xc9, 0xc7, 0xf9, 0xd6,
      0xec, 0x61, 0x0b, 0x7d, 0x11, 0xbf, 0x8f, 0xae, 0xff, 0xa2, 0x02, 0x55,
      0xd1, 0xa1, 0xbe, 0xad, 0x92, 0x97, 0xd0, 0xaa, 0x87, 0x65, 0xcd, 0x28,
      0x05, 0x84, 0x7d, 0x63, 0x9b, 0xc4, 0x39, 0xf4, 0xa6, 0xc8, 0x96, 0xe2,
      0x00, 0x8f, 0x74, 0x6f, 0x95, 0x90, 0xff, 0x45, 0x96, 0xde, 0x5d, 0xdd,
      0xe0, 0x00, 0xed, 0x66, 0x6c, 0x45, 0x2c, 0x97, 0x80, 0x43, 0xff, 0x42,
      0x98, 0x46, 0x1e, 0xb5, 0xa2, 0x6d, 0x5e, 0x63, 0xd8, 0x21, 0x43, 0x86,
      0x27, 0xf9, 0x12, 0x01, 0x92, 0x4b, 0xf7, 0xf2, 0xae, 0xee, 0x17, 0x27},
     {},
     false,
     true},

    // a valid ciphertext that starts with two null bytes and decrypts to
    // 9 byte long value
    {0,
     // 'forty two'
     {0x66, 0x6f, 0x72, 0x74, 0x79, 0x20, 0x74, 0x77, 0x6f},
     {0x00, 0x00, 0x1e, 0xc9, 0x7a, 0xc9, 0x81, 0xdf, 0xd9, 0xdc, 0xc7, 0xa7,
      0x38, 0x9f, 0xdf, 0xa9, 0xd3, 0x61, 0x14, 0x1d, 0xac, 0x80, 0xc2, 0x3a,
      0x06, 0x04, 0x10, 0xd4, 0x72, 0xc1, 0x60, 0x94, 0xe6, 0xcd, 0xff, 0xc0,
      0xc3, 0x68, 0x4d, 0x84, 0xaa, 0x40, 0x2d, 0x70, 0x51, 0xdf, 0xcc, 0xb2,
      0xf6, 0xda, 0x33, 0xf6, 0x69, 0x85, 0xd2, 0xa2, 0x59, 0xf5, 0xb7, 0xfb,
      0xf3, 0x9a, 0xc5, 0x37, 0xe9, 0x5c, 0x5b, 0x70, 0x50, 0xeb, 0x18, 0x84,
      0x4a, 0x05, 0x13, 0xab, 0xef, 0x81, 0x2c, 0xc8, 0xe7, 0x4a, 0x3c, 0x52,
      0x40, 0x00, 0x9e, 0x6e, 0x80, 0x5d, 0xca, 0xdf, 0x53, 0x2b, 0xc1, 0xa2,
      0x70, 0x2d, 0x5a, 0xcc, 0x9e, 0x58, 0x5f, 0xad, 0x5b, 0x89, 0xd4, 0x61,
      0xfc, 0xc1, 0x39, 0x73, 0x51, 0xcd, 0xce, 0x35, 0x17, 0x15, 0x23, 0x75,
      0x8b, 0x17, 0x1d, 0xc0, 0x41, 0xf4, 0x12, 0xe4, 0x29, 0x66, 0xde, 0x7f,
      0x94, 0x85, 0x64, 0x77, 0x35, 0x6d, 0x06, 0xf2, 0xa6, 0xb4, 0x0e, 0x3f,
      0xf0, 0x54, 0x75, 0x62, 0xa4, 0xd9, 0x1b, 0xbf, 0x13, 0x38, 0xe9, 0xe0,
      0x49, 0xfa, 0xcb, 0xee, 0x8b, 0x20, 0x17, 0x11, 0x64, 0x50, 0x54, 0x68,
      0xcd, 0x30, 0x89, 0x97, 0x44, 0x7d, 0x3d, 0xc4, 0xb0, 0xac, 0xb4, 0x9e,
      0x7d, 0x36, 0x8f, 0xed, 0xd8, 0xc7, 0x34, 0x25, 0x1f, 0x30, 0xa8, 0x34,
      0x91, 0xd2, 0x50, 0x6f, 0x3f, 0x87, 0x31, 0x8c, 0xc1, 0x18, 0x82, 0x32,
      0x44, 0xa3, 0x93, 0xdc, 0x7c, 0x5c, 0x73, 0x9a, 0x27, 0x33, 0xd9, 0x3e,
      0x1b, 0x13, 0xdb, 0x68, 0x40, 0xa9, 0x42, 0x99, 0x47, 0x35, 0x7f, 0x47,
      0xb2, 0x3f, 0xbe, 0x39, 0xb7, 0xd2, 0xd6, 0x1e, 0x5e, 0xe2, 0x6f, 0x99,
      0x46, 0xc4, 0x63, 0x2f, 0x6c, 0x46, 0x99, 0xe4, 0x52, 0xf4, 0x12, 0xa2,
      0x66, 0x41, 0xd4, 0x75, 0x11, 0x35, 0x40, 0x07, 0x13, 0xcd, 0x56, 0xec,
      0x66, 0xf0, 0x37, 0x04, 0x23, 0xd5, 0x5d, 0x2a, 0xf7, 0x0f, 0x5e, 0x7a,
      0xd0, 0xad, 0xea, 0x8e, 0x4a, 0x0d, 0x90, 0x4a, 0x01, 0xe4, 0xac, 0x27,
      0x2e, 0xba, 0x4a, 0xf1, 0xa0, 0x29, 0xdd, 0x53, 0xeb, 0x71, 0xf1, 0x15,
      0xbf, 0x31, 0xf7, 0xa6, 0xc8, 0xb1, 0x9a, 0x65, 0x23, 0xad, 0xee, 0xcc,
      0x0d, 0x4c, 0x3c, 0x10, 0x75, 0x75, 0xe3, 0x85, 0x72, 0xa8, 0xf8, 0x47,
      0x4c, 0xca, 0xd1, 0x63, 0xe4, 0x6e, 0x2e, 0x8b, 0x08, 0x11, 0x11, 0x32,
      0xaa, 0x97, 0xa1, 0x6f, 0xb5, 0x88, 0xc9, 0xb7, 0xe3, 0x7b, 0x3b, 0x3d,
      0x74, 0x90, 0x38, 0x1f, 0x3c, 0x55, 0xd1, 0xa9, 0x86, 0x9a, 0x0f, 0xd4,
      0x2c, 0xd8, 0x6f, 0xed, 0x59, 0xec, 0xec, 0x78, 0xcb, 0x6b, 0x2d, 0xfd,
      0x06, 0xa4, 0x97, 0xf5, 0xaf, 0xe3, 0x41, 0x96, 0x91, 0x31, 0x4b, 0xa0},
     {},
     false,
     true},

    // test_negative_9_bytes_long
    {0,
     {0x25, 0x79, 0x06, 0xca, 0x6d, 0xe8, 0x30, 0x77, 0x28},
     {0x5c, 0x85, 0x55, 0xf5, 0xce, 0xf6, 0x27, 0xc1, 0x5d, 0x37, 0xf8, 0x5c,
      0x7f, 0x5f, 0xd6, 0xe4, 0x99, 0x26, 0x4e, 0xa4, 0xb8, 0xe3, 0xf9, 0x11,
      0x20, 0x23, 0xae, 0xb7, 0x22, 0xeb, 0x38, 0xd8, 0xea, 0xc2, 0xbe, 0x37,
      0x51, 0xfd, 0x5a, 0x37, 0x85, 0xab, 0x7f, 0x2d, 0x59, 0xfa, 0x37, 0x28,
      0xe5, 0xbe, 0x8c, 0x3d, 0xe7, 0x8a, 0x67, 0x46, 0x4e, 0x30, 0xb2, 0x1e,
      0xe2, 0x3b, 0x54, 0x84, 0xbb, 0x3c, 0xd0, 0x6d, 0x0e, 0x1c, 0x6a, 0xd2,
      0x56, 0x49, 0xc8, 0x51, 0x81, 0x65, 0x65, 0x3e, 0xb8, 0x04, 0x88, 0xbf,
      0xb4, 0x91, 0xb2, 0x0c, 0x04, 0x89, 0x7a, 0x67, 0x72, 0xf6, 0x92, 0x92,
      0x22, 0x2f, 0xc5, 0xef, 0x50, 0xb5, 0xcf, 0x9e, 0xfc, 0x6d, 0x60, 0x42,
      0x6a, 0x44, 0x9b, 0x6c, 0x48, 0x95, 0x69, 0xd4, 0x8c, 0x83, 0x48, 0x8d,
      0xf6, 0x29, 0xd6, 0x95, 0x65, 0x3d, 0x40, 0x9c, 0xe4, 0x9a, 0x79, 0x54,
      0x47, 0xfc, 0xec, 0x2c, 0x58, 0xa1, 0xa6, 0x72, 0xe4, 0xa3, 0x91, 0x40,
      0x1d, 0x42, 0x8b, 0xaa, 0xf7, 0x81, 0x51, 0x6e, 0x11, 0xe3, 0x23, 0xd3,
      0x02, 0xfc, 0xf2, 0x0f, 0x6e, 0xab, 0x2b, 0x2d, 0xbe, 0x53, 0xa4, 0x8c,
      0x98, 0x7e, 0x40, 0x7c, 0x4d, 0x7e, 0x1c, 0xb4, 0x11, 0x31, 0x32, 0x91,
      0x38, 0x31, 0x3d, 0x33, 0x02, 0x04, 0x17, 0x3a, 0x4f, 0x3f, 0xf0, 0x6c,
      0x6f, 0xad, 0xf9, 0x70, 0xf0, 0xed, 0x10, 0x05, 0xd0, 0xb2, 0x7e, 0x35,
      0xc3, 0xd1, 0x16, 0x93, 0xe0, 0x42, 0x9e, 0x27, 0x2d, 0x58, 0x3e, 0x57,
      0xb2, 0xc5, 0x8d, 0x24, 0x31, 0x5c, 0x39, 0x78, 0x56, 0xb3, 0x44, 0x85,
      0xdc, 0xb0, 0x77, 0x66, 0x55, 0x92, 0xb7, 0x47, 0xf8, 0x89, 0xd3, 0x4f,
      0xeb, 0xf2, 0xbe, 0x8f, 0xce, 0x66, 0xc2, 0x65, 0xfd, 0x9f, 0xc3, 0x57,
      0x5a, 0x62, 0x86, 0xa5, 0xce, 0x88, 0xb4, 0xb4, 0x13, 0xa0, 0x8e, 0xfc,
      0x57, 0xa0, 0x7a, 0x8f, 0x57, 0xa9, 0x99, 0x60, 0x5a, 0x83, 0x7b, 0x05,
      0x42, 0x69, 0x5c, 0x0d, 0x18, 0x9e, 0x67, 0x8b, 0x53, 0x66, 0x2e, 0xcf,
      0x7c, 0x3d, 0x37, 0xd9, 0xdb, 0xee, 0xa5, 0x85, 0xee, 0xbf, 0xaf, 0x79,
      0x14, 0x11, 0x18, 0xe0, 0x67, 0x62, 0xc2, 0x38, 0x1f, 0xe2, 0x7c, 0xa6,
      0x28, 0x8e, 0xdd, 0xdc, 0x19, 0xfd, 0x67, 0xcd, 0x64, 0xf1, 0x6b, 0x46,
      0xe0, 0x6d, 0x8a, 0x59, 0xac, 0x53, 0x0f, 0x22, 0xcd, 0x83, 0xcc, 0x0b,
      0xc4, 0xe3, 0x7f, 0xeb, 0x52, 0x01, 0x5c, 0xbb, 0x22, 0x83, 0x04, 0x3c,
      0xcf, 0x5e, 0x78, 0xa4, 0xeb, 0x71, 0x46, 0x82, 0x7d, 0x7a, 0x46, 0x6b,
      0x66, 0xc8, 0xa4, 0xa4, 0x82, 0x6c, 0x1b, 0xad, 0x68, 0x12, 0x3a, 0x7f,
      0x2d, 0x00, 0xfc, 0x17, 0x36, 0x52, 0x5f, 0xf9, 0x0c, 0x05, 0x8f, 0x56},
     {},
     false,
     true},

    // malformed plaintext that generates a fake plaintext of length
    // specified by 2nd to last value from PRF
    {0,
     {0x04, 0x33, 0x83, 0xc9, 0x29, 0x06, 0x03, 0x74, 0xed},
     {0x75, 0x8c, 0x21, 0x5a, 0xa6, 0xac, 0xd6, 0x12, 0x48, 0x06, 0x2b, 0x88,
      0x28, 0x4b, 0xf4, 0x3c, 0x13, 0xcb, 0x3b, 0x3d, 0x02, 0x41, 0x0b, 0xe4,
      0x23, 0x86, 0x07, 0x44, 0x2f, 0x1c, 0x02, 0x16, 0x70, 0x6e, 0x21, 0xa0,
      0x3a, 0x2c, 0x10, 0xeb, 0x62, 0x4a, 0x63, 0x32, 0x2d, 0x85, 0x4d, 0xa1,
      0x95, 0xc0, 0x17, 0xb7, 0x6f, 0xea, 0x83, 0xe2, 0x74, 0xfa, 0x37, 0x18,
      0x34, 0xdc, 0xd2, 0xf3, 0xb7, 0xac, 0xcf, 0x43, 0x3f, 0xc2, 0x12, 0xad,
      0x76, 0xc0, 0xba, 0xc3, 0x66, 0xe1, 0xed, 0x32, 0xe2, 0x5b, 0x27, 0x9f,
      0x94, 0x12, 0x9b, 0xe7, 0xc6, 0x4d, 0x6e, 0x16, 0x2a, 0xdc, 0x08, 0xcc,
      0xeb, 0xc0, 0xcf, 0xe8, 0xe9, 0x26, 0xf0, 0x1c, 0x33, 0xab, 0x9c, 0x06,
      0x5f, 0x0e, 0x0a, 0xc8, 0x3a, 0xe5, 0x13, 0x7a, 0x4c, 0xb6, 0x67, 0x02,
      0x61, 0x5a, 0xd6, 0x8a, 0x35, 0x70, 0x7d, 0x86, 0x76, 0xd2, 0x74, 0x0d,
      0x7c, 0x1a, 0x95, 0x46, 0x80, 0xc8, 0x39, 0x80, 0xe1, 0x97, 0x78, 0xed,
      0x11, 0xee, 0xd3, 0xa7, 0xc2, 0xdb, 0xdf, 0xc4, 0x61, 0xa9, 0xbb, 0xef,
      0x67, 0x1c, 0x1b, 0xc0, 0x0c, 0x88, 0x2d, 0x36, 0x1d, 0x29, 0xd5, 0xf8,
      0x0c, 0x42, 0xbd, 0xf5, 0xef, 0xec, 0x88, 0x6c, 0x34, 0x13, 0x8f, 0x83,
      0x36, 0x9c, 0x69, 0x33, 0xb2, 0xac, 0x4e, 0x93, 0xe7, 0x64, 0x26, 0x53,
      0x51, 0xb4, 0xa0, 0x08, 0x3f, 0x04, 0x0e, 0x14, 0xf5, 0x11, 0xf0, 0x9b,
      0x22, 0xf9, 0x65, 0x66, 0x13, 0x88, 0x64, 0xe4, 0xe6, 0xff, 0x24, 0xda,
      0x48, 0x10, 0x09, 0x5d, 0xa9, 0x8e, 0x05, 0x85, 0x41, 0x09, 0x51, 0x53,
      0x8c, 0xed, 0x2f, 0x75, 0x7a, 0x27, 0x7f, 0xf8, 0xe1, 0x71, 0x72, 0xf0,
      0x65, 0x72, 0xc9, 0x02, 0x4e, 0xea, 0xe5, 0x03, 0xf1, 0x76, 0xfd, 0x46,
      0xeb, 0x6c, 0x5c, 0xd9, 0xba, 0x07, 0xaf, 0x11, 0xcd, 0xe3, 0x1d, 0xcc,
      0xac, 0x12, 0xeb, 0x3a, 0x42, 0x49, 0xa7, 0xbf, 0xd3, 0xb1, 0x97, 0x97,
      0xad, 0x16, 0x56, 0x98, 0x4b, 0xfc, 0xbf, 0x6f, 0x74, 0xe8, 0xf9, 0x9d,
      0x8f, 0x1a, 0xc4, 0x20, 0x81, 0x1f, 0x3d, 0x16, 0x6d, 0x87, 0xf9, 0x35,
      0xef, 0x15, 0xae, 0x85, 0x8c, 0xf9, 0xe7, 0x2c, 0x8e, 0x2b, 0x54, 0x7b,
      0xf1, 0x6c, 0x3f, 0xb0, 0x9a, 0x8c, 0x9b, 0xf8, 0x8f, 0xd2, 0xe5, 0xd3,
      0x8b, 0xf2, 0x4e, 0xd6, 0x10, 0x89, 0x61, 0x31, 0xa8, 0x4d, 0xf7, 0x6b,
      0x9f, 0x92, 0x0f, 0xe7, 0x6d, 0x71, 0xff, 0xf9, 0x38, 0xe9, 0x19, 0x9f,
      0x3b, 0x8c, 0xd0, 0xc1, 0x1f, 0xd0, 0x20, 0x1f, 0x91, 0x39, 0xd7, 0x67,
      0x3a, 0x87, 0x1a, 0x9e, 0x7d, 0x4a, 0xdc, 0x3b, 0xbe, 0x36, 0x0c, 0x88,
      0x13, 0x61, 0x7c, 0xd6, 0x0a, 0x90, 0x12, 0x8f, 0xbe, 0x34, 0xc9, 0xd5},
     {},
     false,
     true},

    // malformed plaintext that generates a fake plaintext of length
    // specified by 3rd to last value from PRF
    {0,
     {0x70, 0x26, 0x3f, 0xa6, 0x05, 0x05, 0x34, 0xb9, 0xe0},
     {0x7b, 0x22, 0xd5, 0xe6, 0x2d, 0x28, 0x79, 0x68, 0xc6, 0x62, 0x21, 0x71,
      0xa1, 0xf7, 0x5d, 0xb4, 0xb0, 0xfd, 0x15, 0xcd, 0xf3, 0x13, 0x4a, 0x18,
      0x95, 0xd2, 0x35, 0xd5, 0x6f, 0x8d, 0x8f, 0xe6, 0x19, 0xf2, 0xbf, 0x48,
      0x68, 0x17, 0x4a, 0x91, 0xd7, 0x60, 0x1a, 0x82, 0x97, 0x5d, 0x22, 0x55,
      0x19, 0x0d, 0x28, 0xb8, 0x69, 0x14, 0x1d, 0x7c, 0x39, 0x5f, 0x0b, 0x8c,
      0x4e, 0x2b, 0xe2, 0xb2, 0xc1, 0xb4, 0xff, 0xc1, 0x2c, 0xe7, 0x49, 0xa6,
      0xf6, 0x80, 0x3d, 0x4c, 0xfe, 0x7f, 0xba, 0x0a, 0x8d, 0x69, 0x49, 0xc0,
      0x41, 0x51, 0xf9, 0x81, 0xc0, 0xd8, 0x45, 0x92, 0xaa, 0x2f, 0xf2, 0x5d,
      0x1b, 0xd3, 0xce, 0x5d, 0x10, 0xcb, 0x03, 0xda, 0xca, 0x6b, 0x49, 0x6c,
      0x6a, 0xd4, 0x0d, 0x30, 0xbf, 0xa8, 0xac, 0xdf, 0xd0, 0x2c, 0xdb, 0x93,
      0x26, 0xc4, 0xbd, 0xd9, 0x3b, 0x94, 0x9c, 0x9d, 0xc4, 0x6c, 0xaa, 0x8f,
      0x0e, 0x5f, 0x42, 0x97, 0x85, 0xbc, 0xe6, 0x41, 0x36, 0xa4, 0x29, 0xa3,
      0x69, 0x5e, 0xe6, 0x74, 0xb6, 0x47, 0x45, 0x2b, 0xea, 0x1b, 0x0c, 0x6d,
      0xe9, 0xc5, 0xf1, 0xe8, 0x76, 0x0d, 0x5e, 0xf6, 0xd5, 0xa9, 0xcf, 0xff,
      0x40, 0x45, 0x7b, 0x02, 0x3d, 0x3c, 0x23, 0x3c, 0x1d, 0xcb, 0x32, 0x3e,
      0x78, 0x08, 0x10, 0x3e, 0x73, 0x96, 0x3b, 0x2e, 0xaf, 0xc9, 0x28, 0xc9,
      0xee, 0xb0, 0xee, 0x32, 0x94, 0x95, 0x54, 0x15, 0xc1, 0xdd, 0xd9, 0xa1,
      0xbb, 0x7e, 0x13, 0x8f, 0xec, 0xd7, 0x9a, 0x3c, 0xb8, 0x9c, 0x57, 0xbd,
      0x23, 0x05, 0x52, 0x46, 0x24, 0x81, 0x4a, 0xaf, 0x0f, 0xd1, 0xac, 0xbf,
      0x37, 0x9f, 0x7f, 0x5b, 0x39, 0x42, 0x1f, 0x12, 0xf1, 0x15, 0xba, 0x48,
      0x8d, 0x38, 0x05, 0x86, 0x09, 0x5b, 0xb5, 0x3f, 0x17, 0x4f, 0xae, 0x42,
      0x4f, 0xa4, 0xc8, 0xe3, 0xb2, 0x99, 0x70, 0x9c, 0xd3, 0x44, 0xb9, 0xf9,
      0x49, 0xb1, 0xab, 0x57, 0xf1, 0xc6, 0x45, 0xd7, 0xed, 0x3c, 0x8f, 0x81,
      0xd5, 0x59, 0x41, 0x97, 0x35, 0x50, 0x29, 0xfe, 0xe8, 0x96, 0x09, 0x70,
      0xff, 0x59, 0x71, 0x0d, 0xc0, 0xe5, 0xeb, 0x50, 0xea, 0x6f, 0x4c, 0x39,
      0x38, 0xe3, 0xf8, 0x9e, 0xd7, 0x93, 0x30, 0x23, 0xa2, 0xc2, 0xdd, 0xff,
      0xab, 0xa0, 0x7b, 0xe1, 0x47, 0xf6, 0x86, 0x82, 0x8b, 0xd7, 0xd5, 0x20,
      0xf3, 0x00, 0x50, 0x7e, 0xd6, 0xe7, 0x1b, 0xda, 0xee, 0x05, 0x57, 0x0b,
      0x27, 0xbc, 0x92, 0x74, 0x11, 0x08, 0xac, 0x2e, 0xb4, 0x33, 0xf0, 0x28,
      0xe1, 0x38, 0xdd, 0x6d, 0x63, 0x06, 0x7b, 0xc2, 0x06, 0xea, 0x2d, 0x82,
      0x6a, 0x7f, 0x41, 0xc0, 0xd6, 0x13, 0xda, 0xed, 0x02, 0x0f, 0x0f, 0x30,
      0xf4, 0xe2, 0x72, 0xe9, 0x61, 0x8e, 0x0a, 0x8c, 0x39, 0x01, 0x8a, 0x83},
     {},
     false,
     true},

    // an otherwise correct plaintext, but with wrong first byte
    // (0x01 instead of 0x00), generates a random 9 byte long plaintext
    {0,
     {0x6d, 0x8d, 0x3a, 0x09, 0x4f, 0xf3, 0xaf, 0xff, 0x4c},
     {0x6d, 0xb8, 0x0a, 0xdb, 0x5f, 0xf0, 0xa7, 0x68, 0xca, 0xf1, 0x37, 0x8e,
      0xcc, 0x38, 0x2a, 0x69, 0x4e, 0x7d, 0x1b, 0xde, 0x2e, 0xff, 0x4b, 0xa1,
      0x2c, 0x48, 0xaa, 0xf7, 0x94, 0xde, 0xd7, 0xa9, 0x94, 0xa5, 0xb2, 0xb5,
      0x7a, 0xce, 0xc2, 0x0d, 0xbe, 0xc4, 0xae, 0x38, 0x5c, 0x9d, 0xd5, 0x31,
      0x94, 0x5c, 0x0f, 0x19, 0x7a, 0x54, 0x96, 0x90, 0x87, 0x25, 0xfc, 0x99,
      0xd8, 0x86, 0x01, 0xa1, 0x7d, 0x3b, 0xb0, 0xb2, 0xd3, 0x8d, 0x2c, 0x1c,
      0x31, 0x00, 0xf3, 0x99, 0x55, 0xa4, 0xcb, 0x3d, 0xbe, 0xd5, 0xa3, 0x8b,
      0xf9, 0x00, 0xf2, 0x3d, 0x91, 0xe1, 0x73, 0x64, 0x0e, 0x4e, 0xc6, 0x55,
      0xc8, 0x4f, 0xdf, 0xe7, 0x1f, 0xcd, 0xb1, 0x2a, 0x38, 0x61, 0x08, 0xfc,
      0xf7, 0x18, 0xc9, 0xb7, 0xaf, 0x37, 0xd3, 0x97, 0x03, 0xe8, 0x82, 0x43,
      0x62, 0x24, 0xc8, 0x77, 0xa2, 0x23, 0x5e, 0x83, 0x44, 0xfb, 0xa6, 0xc9,
      0x51, 0xeb, 0x7e, 0x2a, 0x4d, 0x1d, 0x1d, 0xe8, 0x1f, 0xb4, 0x63, 0xac,
      0x1b, 0x88, 0x0f, 0x6c, 0xc0, 0xe5, 0x9a, 0xde, 0x05, 0xc8, 0xce, 0x35,
      0x17, 0x9e, 0xcd, 0x09, 0x54, 0x67, 0x31, 0xfc, 0x07, 0xb1, 0x41, 0xd3,
      0xd6, 0xb3, 0x42, 0xa9, 0x7a, 0xe7, 0x47, 0xe6, 0x1a, 0x91, 0x30, 0xf7,
      0x2d, 0x37, 0xac, 0x5a, 0x2c, 0x30, 0x21, 0x5b, 0x6c, 0xbd, 0x66, 0xc7,
      0xdb, 0x89, 0x38, 0x10, 0xdf, 0x58, 0xb4, 0xc4, 0x57, 0xb4, 0xb5, 0x4f,
      0x34, 0x42, 0x82, 0x47, 0xd5, 0x84, 0xe0, 0xfa, 0x71, 0x06, 0x24, 0x46,
      0x21, 0x0d, 0xb0, 0x82, 0x54, 0xfb, 0x9e, 0xad, 0x1b, 0xa1, 0xa3, 0x93,
      0xc7, 0x24, 0xbd, 0x29, 0x1f, 0x0c, 0xf1, 0xa7, 0x14, 0x3f, 0x32, 0xdf,
      0x84, 0x90, 0x51, 0xdc, 0x89, 0x6d, 0x7d, 0x17, 0x6f, 0xef, 0x3b, 0x57,
      0xab, 0x6d, 0xff, 0xd6, 0x26, 0xd0, 0xc3, 0x04, 0x4e, 0x9e, 0xdb, 0x2e,
      0x3d, 0x01, 0x2a, 0xce, 0x20, 0x2d, 0x25, 0x81, 0xdf, 0x01, 0xbe, 0xc7,
      0xe9, 0xaa, 0x07, 0x27, 0xa6, 0x65, 0x0d, 0xd3, 0x73, 0xd3, 0x74, 0xf0,
      0xbc, 0x0f, 0x4a, 0x61, 0x1f, 0x81, 0x39, 0xdf, 0xe9, 0x7d, 0x63, 0xe7,
      0x0c, 0x61, 0x88, 0xf4, 0xdf, 0x5b, 0x67, 0x2e, 0x47, 0xc5, 0x1d, 0x8a,
      0xa5, 0x67, 0x09, 0x72, 0x93, 0xfb, 0xff, 0x12, 0x7c, 0x75, 0xec, 0x69,
      0x0b, 0x43, 0x40, 0x75, 0x78, 0xb7, 0x3c, 0x85, 0x45, 0x17, 0x10, 0xa0,
      0xce, 0xce, 0x58, 0xfd, 0x49, 0x7d, 0x7f, 0x7b, 0xd3, 0x6a, 0x8a, 0x92,
      0x78, 0x3e, 0xf7, 0xdc, 0x62, 0x65, 0xdf, 0xf5, 0x2a, 0xac, 0x8b, 0x70,
      0x34, 0x0b, 0x99, 0x65, 0x08, 0xd3, 0x92, 0x17, 0xf2, 0x78, 0x3c, 0xe6,
      0xfc, 0x91, 0xa1, 0xcc, 0x94, 0xbb, 0x2a, 0xc4, 0x87, 0xb8, 0x4f, 0x62},
     {},
     false,
     true},

    // an otherwise correct plaintext, but with wrong second byte
    // (0x01 instead of 0x02), generates a random 9 byte long plaintext
    {0,
     {0xc6, 0xae, 0x80, 0xff, 0xa8, 0x0b, 0xc1, 0x84, 0xb0},
     {0x41, 0x73, 0x28, 0xc0, 0x34, 0x45, 0x85, 0x63, 0x07, 0x9a, 0x40, 0x24,
      0x81, 0x7d, 0x01, 0x50, 0x34, 0x0c, 0x34, 0xe2, 0x5a, 0xe1, 0x6d, 0xca,
      0xd6, 0x90, 0x62, 0x3f, 0x70, 0x2e, 0x5c, 0x74, 0x8a, 0x6e, 0xbb, 0x34,
      0x19, 0xff, 0x48, 0xf4, 0x86, 0xf8, 0x3b, 0xa9, 0xdf, 0x35, 0xc0, 0x5e,
      0xfb, 0xd7, 0xf4, 0x06, 0x13, 0xf0, 0xfc, 0x99, 0x6c, 0x53, 0x70, 0x6c,
      0x30, 0xdf, 0x6b, 0xba, 0x6d, 0xcd, 0x4a, 0x40, 0x82, 0x5f, 0x96, 0x13,
      0x3f, 0x3c, 0x21, 0x63, 0x8a, 0x34, 0x2b, 0xd4, 0x66, 0x3d, 0xff, 0xbd,
      0x00, 0x73, 0x98, 0x0d, 0xac, 0x47, 0xf8, 0xc1, 0xdd, 0x8e, 0x97, 0xce,
      0x14, 0x12, 0xe4, 0xf9, 0x1f, 0x2a, 0x8a, 0xdb, 0x1a, 0xc2, 0xb1, 0x07,
      0x10, 0x66, 0xef, 0xe8, 0xd7, 0x18, 0xbb, 0xb8, 0x8c, 0xa4, 0xa5, 0x9b,
      0xd6, 0x15, 0x00, 0xe8, 0x26, 0xf2, 0x36, 0x52, 0x55, 0xa4, 0x09, 0xbe,
      0xce, 0x0f, 0x97, 0x2d, 0xf9, 0x7c, 0x3a, 0x55, 0xe0, 0x92, 0x89, 0xef,
      0x5f, 0xa8, 0x15, 0xa2, 0x35, 0x3e, 0xf3, 0x93, 0xfd, 0x1a, 0xec, 0xfc,
      0x88, 0x8d, 0x61, 0x1c, 0x16, 0xae, 0xc5, 0x32, 0xe5, 0x14, 0x8b, 0xe1,
      0x5e, 0xf1, 0xbf, 0x28, 0x34, 0xb8, 0xf7, 0x5b, 0xb2, 0x6d, 0xb0, 0x8b,
      0x66, 0xd2, 0xba, 0xad, 0x64, 0x64, 0xf8, 0x43, 0x9d, 0x19, 0x86, 0xb5,
      0x33, 0x81, 0x33, 0x21, 0xdb, 0xb1, 0x80, 0x08, 0x09, 0x10, 0xf2, 0x33,
      0xbc, 0xc4, 0xdd, 0x78, 0x4f, 0xb2, 0x18, 0x71, 0xae, 0xf4, 0x1b, 0xe0,
      0x8b, 0x7b, 0xfa, 0xd4, 0xec, 0xc3, 0xb6, 0x8f, 0x22, 0x8c, 0xb5, 0x31,
      0x7a, 0xc6, 0xec, 0x12, 0x27, 0xbc, 0x7d, 0x0e, 0x45, 0x20, 0x37, 0xba,
      0x91, 0x8e, 0xe1, 0xda, 0x9f, 0xdb, 0x83, 0x93, 0xae, 0x93, 0xb1, 0xe9,
      0x37, 0xa8, 0xd4, 0x69, 0x1a, 0x17, 0x87, 0x1d, 0x50, 0x92, 0xd2, 0x38,
      0x4b, 0x61, 0x90, 0xa5, 0x3d, 0xf8, 0x88, 0xf6, 0x5b, 0x95, 0x1b, 0x05,
      0xed, 0x4a, 0xd5, 0x7f, 0xe4, 0xb0, 0xc6, 0xa4, 0x7b, 0x5b, 0x22, 0xf3,
      0x2a, 0x7f, 0x23, 0xc1, 0xa2, 0x34, 0xc9, 0xfe, 0xb5, 0xd8, 0x71, 0x3d,
      0x94, 0x96, 0x86, 0x76, 0x06, 0x80, 0xda, 0x4d, 0xb4, 0x54, 0xf4, 0xac,
      0xad, 0x97, 0x24, 0x70, 0x03, 0x34, 0x72, 0xb9, 0x86, 0x4d, 0x63, 0xe8,
      0xd2, 0x3e, 0xef, 0xc8, 0x7e, 0xbc, 0xf4, 0x64, 0xec, 0xf3, 0x3f, 0x67,
      0xfb, 0xcd, 0xd4, 0x8e, 0xab, 0x38, 0xc5, 0x29, 0x25, 0x86, 0xb3, 0x6a,
      0xef, 0x59, 0x81, 0xed, 0x2f, 0xa0, 0x7b, 0x2f, 0x9e, 0x23, 0xfc, 0x57,
      0xd9, 0xeb, 0x71, 0xbf, 0xff, 0x41, 0x11, 0xc8, 0x57, 0xe9, 0xff, 0xf2,
      0x3c, 0xeb, 0x31, 0xe7, 0x25, 0x92, 0xe7, 0x0c, 0x87, 0x4b, 0x49, 0x36},
     {},
     false,
     true},

    // an otherwise correct plaintext, but with wrong third byte
    // (0x00 instead of non-zero), generates a random 9 byte long plaintext
    {0,
     {0xa8, 0xa9, 0x30, 0x1d, 0xaa, 0x01, 0xbb, 0x25, 0xc7},
     {0x85, 0x42, 0xc6, 0x26, 0xfe, 0x53, 0x34, 0x67, 0xac, 0xff, 0xcd, 0x4e,
      0x61, 0x76, 0x92, 0x24, 0x4c, 0x9b, 0x5a, 0x3b, 0xf0, 0xa2, 0x15, 0xc5,
      0xd6, 0x48, 0x91, 0xce, 0xd4, 0xbf, 0x4f, 0x95, 0x91, 0xb4, 0xb2, 0xae,
      0xdf, 0xf9, 0x84, 0x30, 0x57, 0x98, 0x6d, 0x81, 0x63, 0x1b, 0x0a, 0xcb,
      0x37, 0x04, 0xec, 0x21, 0x80, 0xe5, 0x69, 0x6e, 0x8b, 0xd1, 0x5b, 0x21,
      0x7a, 0x0e, 0xc3, 0x6d, 0x20, 0x61, 0xb0, 0xe2, 0x18, 0x2f, 0xaa, 0x3d,
      0x1c, 0x59, 0xbd, 0x3f, 0x90, 0x86, 0xa1, 0x00, 0x77, 0xa3, 0x33, 0x7a,
      0x3f, 0x5d, 0xa5, 0x03, 0xec, 0x37, 0x53, 0x53, 0x5f, 0xfd, 0x25, 0xb8,
      0x37, 0xa1, 0x2f, 0x25, 0x41, 0xaf, 0xef, 0xd0, 0xcf, 0xfb, 0x02, 0x24,
      0xb8, 0xf8, 0x74, 0xe4, 0xbe, 0xd1, 0x39, 0x49, 0xe1, 0x05, 0xc0, 0x75,
      0xed, 0x44, 0xe2, 0x87, 0xc5, 0xae, 0x03, 0xb1, 0x55, 0xe0, 0x6b, 0x90,
      0xed, 0x24, 0x7d, 0x2c, 0x07, 0xf1, 0xef, 0x33, 0x23, 0xe3, 0x50, 0x8c,
      0xce, 0x4e, 0x40, 0x74, 0x60, 0x6c, 0x54, 0x17, 0x2a, 0xd7, 0x4d, 0x12,
      0xf8, 0xc3, 0xa4, 0x7f, 0x65, 0x4a, 0xd6, 0x71, 0x10, 0x4b, 0xf7, 0x68,
      0x1e, 0x5b, 0x06, 0x18, 0x62, 0x74, 0x7d, 0x9a, 0xfd, 0x37, 0xe0, 0x7d,
      0x8e, 0x0e, 0x22, 0x91, 0xe0, 0x1f, 0x14, 0xa9, 0x5a, 0x1b, 0xb4, 0xcb,
      0xb4, 0x7c, 0x30, 0x4e, 0xf0, 0x67, 0x59, 0x5a, 0x39, 0x47, 0xee, 0x2d,
      0x72, 0x20, 0x67, 0xe3, 0x8a, 0x0f, 0x04, 0x6f, 0x43, 0xec, 0x29, 0xca,
      0xc6, 0xa8, 0x80, 0x1c, 0x6e, 0x3e, 0x9a, 0x23, 0x31, 0xb1, 0xd4, 0x5a,
      0x7a, 0xa2, 0xc6, 0xaf, 0x32, 0x05, 0xbe, 0x38, 0x2d, 0xd0, 0x26, 0xe3,
      0x89, 0x61, 0x4e, 0xe0, 0x95, 0x66, 0x5a, 0x61, 0x1a, 0xb2, 0xe8, 0xdc,
      0xed, 0x2e, 0xe1, 0xc9, 0xd0, 0x8a, 0xc9, 0xde, 0x11, 0xae, 0xf5, 0xb3,
      0x80, 0x3f, 0xc9, 0xa9, 0xce, 0x82, 0x31, 0xec, 0x87, 0xb5, 0xfe, 0xd3,
      0x86, 0xfb, 0x92, 0xee, 0x3d, 0xb9, 0x95, 0xa8, 0x93, 0x07, 0xbc, 0xba,
      0x84, 0x4b, 0xd0, 0xa6, 0x91, 0xc2, 0x9a, 0xe5, 0x12, 0x16, 0xe9, 0x49,
      0xdf, 0xc8, 0x13, 0x13, 0x3c, 0xb0, 0x6a, 0x07, 0x26, 0x5f, 0xd8, 0x07,
      0xbc, 0xb3, 0x37, 0x7f, 0x6a, 0xdb, 0x0a, 0x48, 0x1d, 0x9b, 0x7f, 0x44,
      0x20, 0x03, 0x11, 0x58, 0x95, 0x93, 0x97, 0x73, 0xe6, 0xb9, 0x53, 0x71,
      0xc4, 0xfe, 0xbe, 0xf2, 0x9e, 0xda, 0xe9, 0x46, 0xfa, 0x24, 0x5e, 0x7c,
      0x50, 0x72, 0x9e, 0x2e, 0x55, 0x8c, 0xfa, 0xad, 0x77, 0x3d, 0x1f, 0xd5,
      0xf6, 0x7b, 0x45, 0x7a, 0x6d, 0x9d, 0x17, 0xa8, 0x47, 0xc6, 0xfc, 0xbd,
      0xb1, 0x03, 0xa8, 0x6f, 0x35, 0xf2, 0x28, 0xce, 0xfc, 0x06, 0xce, 0xa0},
     {},
     false,
     true},

    // an otherwise correct plaintext, but with wrong tenth byte
    // (0x00 instead of non-zero), generates a random 9 byte long plaintext
    {0,
     {0x6c, 0x71, 0x6f, 0xe0, 0x1d, 0x44, 0x39, 0x80, 0x18},
     {0x44, 0x9d, 0xfa, 0x23, 0x7a, 0x70, 0xa9, 0x9c, 0xb0, 0x35, 0x17, 0x93,
      0xec, 0x86, 0x77, 0x88, 0x20, 0x21, 0xc2, 0xaa, 0x74, 0x35, 0x80, 0xbf,
      0x6a, 0x0e, 0xa6, 0x72, 0x05, 0x5c, 0xff, 0xe8, 0x30, 0x3a, 0xc4, 0x28,
      0x55, 0xb1, 0xd1, 0xf3, 0x37, 0x3a, 0xae, 0x6a, 0xf0, 0x9c, 0xb9, 0x07,
      0x41, 0x80, 0xfc, 0x96, 0x3e, 0x9d, 0x14, 0x78, 0xa4, 0xf9, 0x8b, 0x3b,
      0x48, 0x61, 0xd3, 0xe7, 0xf0, 0xaa, 0x85, 0x60, 0xcf, 0x60, 0x37, 0x11,
      0xf1, 0x39, 0xdb, 0x77, 0x66, 0x7c, 0xa1, 0x4b, 0xa3, 0xa1, 0xac, 0xde,
      0xdf, 0xca, 0x9e, 0xf4, 0x60, 0x3d, 0x6d, 0x7e, 0xb0, 0x64, 0x5b, 0xfc,
      0x80, 0x53, 0x04, 0xf9, 0xad, 0x9d, 0x77, 0xd3, 0x47, 0x62, 0xce, 0x5c,
      0xd8, 0x4b, 0xd3, 0xec, 0x9d, 0x35, 0xc3, 0x0e, 0x3b, 0xe7, 0x2a, 0x1e,
      0x8d, 0x35, 0x5d, 0x56, 0x74, 0xa1, 0x41, 0xb5, 0x53, 0x06, 0x59, 0xad,
      0x64, 0xeb, 0xb6, 0x08, 0x2e, 0x6f, 0x73, 0xa8, 0x08, 0x32, 0xab, 0x63,
      0x88, 0x91, 0x25, 0x38, 0x91, 0x46, 0x54, 0xd3, 0x46, 0x02, 0xf4, 0xb3,
      0xb1, 0xc7, 0x85, 0x89, 0xb4, 0xa5, 0xd9, 0x64, 0xb2, 0xef, 0xcc, 0xa1,
      0xdc, 0x70, 0x04, 0xc4, 0x1f, 0x6c, 0xaf, 0xcb, 0x5a, 0x71, 0x59, 0xa7,
      0xfc, 0x7c, 0x03, 0x98, 0x60, 0x4d, 0x0e, 0xdb, 0xd4, 0xc8, 0xf4, 0xf0,
      0x40, 0x67, 0xda, 0x6a, 0x15, 0x3a, 0x05, 0xe7, 0xcb, 0xee, 0xa1, 0x3b,
      0x5e, 0xe4, 0x12, 0x40, 0x0e, 0xf7, 0xd4, 0xf3, 0x10, 0x6f, 0x47, 0x98,
      0xda, 0x70, 0x7e, 0xc3, 0x7a, 0x11, 0x28, 0x6d, 0xf2, 0xb7, 0xa2, 0x04,
      0x85, 0x6d, 0x5f, 0xf7, 0x73, 0x61, 0x3f, 0xd1, 0xe4, 0x53, 0xa7, 0x11,
      0x4b, 0x78, 0xe3, 0x47, 0xd3, 0xe8, 0x07, 0x8e, 0x1c, 0xb3, 0x27, 0x6b,
      0x35, 0x62, 0x48, 0x6b, 0xa6, 0x30, 0xbf, 0x71, 0x96, 0x97, 0xe0, 0x07,
      0x3a, 0x12, 0x3c, 0x3e, 0x60, 0xeb, 0xb5, 0xc7, 0xa1, 0xcc, 0xff, 0x42,
      0x79, 0xfa, 0xff, 0xa2, 0x40, 0x2b, 0xc1, 0x10, 0x9f, 0x8d, 0x55, 0x9d,
      0x67, 0x66, 0xe7, 0x35, 0x91, 0x94, 0x3d, 0xfc, 0xf2, 0x5b, 0xa1, 0x0c,
      0x37, 0x62, 0xf0, 0x2a, 0xf8, 0x51, 0x87, 0x79, 0x9b, 0x8b, 0x4b, 0x13,
      0x5c, 0x39, 0x90, 0x79, 0x3a, 0x6f, 0xd3, 0x26, 0x42, 0xf1, 0x55, 0x74,
      0x05, 0xba, 0x55, 0xcc, 0x7c, 0xf7, 0x33, 0x6a, 0x0e, 0x96, 0x70, 0x73,
      0xc5, 0xfa, 0x50, 0x74, 0x3f, 0x9c, 0xc5, 0xe3, 0x01, 0x7c, 0x17, 0x2d,
      0x98, 0x98, 0xd2, 0xaf, 0x83, 0x34, 0x5e, 0x71, 0xb3, 0xe0, 0xc2, 0x2a,
      0xb7, 0x91, 0xea, 0xcb, 0x64, 0x84, 0xa3, 0x2e, 0xc6, 0x0e, 0xbc, 0x22,
      0x6e, 0xc9, 0xde, 0xae, 0xe9, 0x1b, 0x1a, 0x05, 0x60, 0xc2, 0xb5, 0x71},
     {},
     false,
     true},

    // an otherwise correct plaintext, but with the null byte specifying
    // end of padding missing, generates a random 9 byte long plaintext
    {0,
     {0xaa, 0x2d, 0xe6, 0xcd, 0xe4, 0xe2, 0x44, 0x28, 0x84},
     {0xa7, 0xa5, 0xc9, 0x9e, 0x50, 0xda, 0x48, 0x76, 0x9e, 0xcb, 0x77, 0x9d,
      0x9a, 0xbe, 0x86, 0xef, 0x9e, 0xc8, 0xc3, 0x8c, 0x6f, 0x43, 0xf1, 0x7c,
      0x7f, 0x2d, 0x7a, 0xf6, 0x08, 0xa4, 0xa1, 0xbd, 0x6c, 0xf6, 0x95, 0xb4,
      0x7e, 0x97, 0xc1, 0x91, 0xc6, 0x1f, 0xb5, 0xa2, 0x73, 0x18, 0xd0, 0x2f,
      0x49, 0x5a, 0x17, 0x6b, 0x9f, 0xae, 0x5a, 0x55, 0xb5, 0xd3, 0xfa, 0xbd,
      0x1d, 0x8a, 0xae, 0x49, 0x57, 0xe3, 0x87, 0x9c, 0xb0, 0xc6, 0x0f, 0x03,
      0x77, 0x24, 0xe1, 0x1b, 0xe5, 0xf3, 0x0f, 0x08, 0xfc, 0x51, 0xc0, 0x33,
      0x73, 0x1f, 0x14, 0xb4, 0x4b, 0x41, 0x4d, 0x11, 0x27, 0x8c, 0xd3, 0xdb,
      0xa7, 0xe1, 0xc8, 0xbf, 0xe2, 0x08, 0xd2, 0xb2, 0xbb, 0x7e, 0xc3, 0x63,
      0x66, 0xda, 0xcb, 0x6c, 0x88, 0xb2, 0x4c, 0xd7, 0x9a, 0xb3, 0x94, 0xad,
      0xf1, 0x9d, 0xbb, 0xc2, 0x1d, 0xfa, 0x57, 0x88, 0xba, 0xcb, 0xad, 0xc6,
      0xa6, 0x2f, 0x79, 0xcf, 0x54, 0xfd, 0x8c, 0xf5, 0x85, 0xc6, 0x15, 0xb5,
      0xc0, 0xeb, 0x94, 0xc3, 0x5a, 0xa9, 0xde, 0x25, 0x32, 0x1c, 0x8f, 0xfe,
      0xfb, 0x89, 0x16, 0xbb, 0xaa, 0x26, 0x97, 0xcb, 0x2d, 0xd8, 0x2e, 0xe9,
      0x89, 0x39, 0xdf, 0x9b, 0x67, 0x04, 0xce, 0xe7, 0x77, 0x93, 0xed, 0xd2,
      0xb4, 0x94, 0x7d, 0x82, 0xe0, 0x0e, 0x57, 0x49, 0x66, 0x49, 0x70, 0x73,
      0x6c, 0x59, 0xa8, 0x41, 0x97, 0xbd, 0x72, 0xb5, 0xc7, 0x1e, 0x36, 0xaa,
      0xe2, 0x9c, 0xd3, 0x9a, 0xf6, 0xac, 0x73, 0xa3, 0x68, 0xed, 0xbc, 0x1c,
      0xa7, 0x92, 0xe1, 0x30, 0x9f, 0x44, 0x2a, 0xaf, 0xcd, 0x77, 0xc9, 0x92,
      0xc8, 0x8f, 0x8e, 0x48, 0x63, 0x14, 0x9f, 0x22, 0x16, 0x95, 0xcb, 0x7b,
      0x02, 0x36, 0xe7, 0x5b, 0x23, 0x39, 0xa0, 0x2c, 0x4e, 0xa1, 0x14, 0x85,
      0x43, 0x72, 0xc3, 0x06, 0xb9, 0x41, 0x2d, 0x8e, 0xed, 0xb6, 0x00, 0xa3,
      0x15, 0x32, 0x00, 0x2f, 0x2c, 0xea, 0x07, 0xb4, 0xdf, 0x96, 0x3a, 0x09,
      0x31, 0x85, 0xe4, 0x60, 0x77, 0x32, 0xe4, 0x6d, 0x75, 0x3b, 0x54, 0x09,
      0x74, 0xfb, 0x5a, 0x5c, 0x3f, 0x94, 0x32, 0xdf, 0x22, 0xe8, 0x5b, 0xb1,
      0x76, 0x11, 0x37, 0x09, 0x66, 0xc5, 0x52, 0x2f, 0xd2, 0x3f, 0x2a, 0xd3,
      0x48, 0x43, 0x41, 0xba, 0x7f, 0xd8, 0x88, 0x5f, 0xc8, 0xe6, 0xd3, 0x79,
      0xa6, 0x11, 0xd1, 0x3a, 0x2a, 0xca, 0x78, 0x4f, 0xba, 0x20, 0x73, 0x20,
      0x8f, 0xaa, 0xd2, 0x13, 0x7b, 0xf1, 0x97, 0x9a, 0x0f, 0xa1, 0x46, 0xc1,
      0x88, 0x0d, 0x43, 0x37, 0xdb, 0x32, 0x74, 0x26, 0x94, 0x93, 0xba, 0xb4,
      0x4a, 0x1b, 0xcd, 0x06, 0x81, 0xf7, 0x22, 0x7f, 0xfd, 0xf5, 0x89, 0xc2,
      0xe9, 0x25, 0xed, 0x9d, 0x36, 0x30, 0x25, 0x09, 0xd1, 0x10, 0x9b, 0xa4},
     {},
     false,
     true}};

#endif  // rsaencrypt_bb3072_vectors_h__
