/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.IndiPanel;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.values.NoEvenEnum;
import genj.util.WordBuffer;
import javax.swing.JLabel;
import org.openide.util.NbBundle;

public class EventLabel
extends JLabel {
    private String tag = "";
    private String tableLabel = "";
    private String shortLabel = "";
    private String longLabel = "";

    public EventLabel(Property property) {
        this.tag = property.getTag();
        this.resetLabels(property);
    }

    public String getTag() {
        return this.tag;
    }

    public void resetLabels(Property property) {
        if (property instanceof Indi) {
            this.shortLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameShort");
            this.longLabel = NbBundle.getMessage(this.getClass(), (String)"IndiEventNameLong");
            this.tableLabel = this.shortLabel;
        } else if (this.tag.equals("NO")) {
            NoEvenEnum labelEnum;
            String labelNo;
            String prefix = NbBundle.getMessage(IndiPanel.class, (String)"EventMenu_NonEventPrefix");
            Object str = prefix + "-" + (labelNo = (labelEnum = NoEvenEnum.valueOf((String)property.getValue())).getDisplayValue());
            if (((String)str).contains(" ")) {
                str = ((String)str).substring(0, ((String)str).indexOf(" "));
            }
            this.shortLabel = str;
            this.tableLabel = str;
            this.longLabel = str;
        } else {
            Property place;
            String str = property.getPropertyName();
            if (str.contains(" ")) {
                str = str.substring(0, str.indexOf(" "));
            }
            this.shortLabel = str;
            this.tableLabel = str;
            WordBuffer buffer = new WordBuffer(" - ");
            buffer.append(this.shortLabel);
            Property date = property.getProperty("DATE");
            if (date != null && date instanceof PropertyDate) {
                PropertyDate pDate = (PropertyDate)date;
                buffer.append(pDate.getDisplayValue());
            }
            if ((place = property.getProperty("PLAC")) != null) {
                PropertyPlace pPlace = (PropertyPlace)place;
                buffer.append(pPlace.getCity());
            }
            this.longLabel = buffer.toString();
        }
        this.setText(this.shortLabel);
    }

    public void setTableLabel(String label) {
        if (!label.isEmpty()) {
            this.tableLabel = label;
        }
    }

    public String getTableLabel() {
        return this.tableLabel;
    }

    public String getShortLabel() {
        return this.shortLabel;
    }

    public String getLongLabel() {
        return this.longLabel;
    }
}

