/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.gedart.DocReport;
import ancestris.reports.gedart.GedartTemplate;
import ancestris.reports.gedart.GedartTemplates;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

public class ReportGedart
extends Report {
    private String todoTag = "NOTE";
    private String todoStart = "TODO:";
    private boolean outputSummary = false;
    private boolean isTodo = false;
    private boolean isOneFile = true;
    private DocReport mydoc;
    private Gedcom theGedcom;
    private GedartTemplates gedartTemplates = new GedartTemplates();
    private GedartTemplate[] gedartTemplatesOption = this.gedartTemplates.toArray();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    public int templateModel = 0;
    public String[] templateModels = GedartTemplate.getDescription(this.gedartTemplatesOption);
    public boolean includeIndi = true;
    public boolean includeFam = true;
    public boolean includeBlankCells = false;
    public boolean showID = true;
    public boolean includeTOC = false;
    public boolean includeIndex = false;
    public boolean saveReportToFile = true;

    public String accepts(Object context) {
        return this.getName();
    }

    public File start(Gedcom gedcom, GedartTemplate template) {
        this.theGedcom = gedcom;
        List<Indi> indis = this.scope.getScope(gedcom, this);
        if (indis == null) {
            return null;
        }
        Indi[] indiArray = (Indi[])indis.toArray(Indi[]::new);
        return this.process((Entity[])indiArray, (Entity[])this.getFams(indiArray), template);
    }

    public File start(Indi indi, GedartTemplate template) {
        this.theGedcom = indi.getGedcom();
        Fam[] fams = indi.getFamiliesWhereSpouse(true);
        return this.process((Entity[])new Indi[]{indi}, (Entity[])fams, template);
    }

    public File start(Indi[] indis, GedartTemplate template) {
        this.theGedcom = indis[0].getGedcom();
        return this.process((Entity[])indis, (Entity[])this.getFams(indis), template);
    }

    public File start(Fam fam, GedartTemplate template) {
        this.theGedcom = fam.getGedcom();
        Fam[] fams = new Fam[]{fam};
        return this.process((Entity[])this.getIndis(fams), (Entity[])fams, template);
    }

    public File start(Fam[] fams, GedartTemplate template) {
        this.theGedcom = fams[0].getGedcom();
        return this.process((Entity[])this.getIndis(fams), (Entity[])fams, template);
    }

    public File start(Object context) throws Throwable {
        if (context instanceof Gedcom) {
            return this.start((Gedcom)context, null);
        }
        if (context instanceof Indi) {
            return this.start((Indi)context, null);
        }
        if (context instanceof Fam) {
            return this.start((Fam)context, null);
        }
        if (context instanceof Indi[]) {
            return this.start((Indi[])context, null);
        }
        if (context instanceof Fam[]) {
            return this.start((Fam[])context, null);
        }
        return null;
    }

    private Fam[] getFams(Indi[] indis) {
        HashSet<Fam> fams = new HashSet<Fam>();
        if (this.includeFam) {
            for (Indi indi : indis) {
                for (Fam fam : indi.getFamiliesWhereSpouse(true)) {
                    fams.add(fam);
                }
            }
        }
        return (Fam[])fams.toArray(Fam[]::new);
    }

    private Indi[] getIndis(Fam[] fams) {
        HashSet<Indi> indis = new HashSet<Indi>();
        for (Fam fam : fams) {
            Indi wife;
            Indi husb = fam.getHusband();
            if (husb != null) {
                indis.add(husb);
            }
            if ((wife = fam.getWife()) == null) continue;
            indis.add(wife);
        }
        return (Indi[])indis.toArray(Indi[]::new);
    }

    private File process(Entity[] indis, Entity[] fams, GedartTemplate usetemplate) {
        File file;
        boolean isOneEntity;
        String extension = null;
        if (usetemplate == null && this.gedartTemplatesOption.length > this.templateModel) {
            usetemplate = this.gedartTemplatesOption[this.templateModel];
        }
        if (usetemplate == null) {
            return null;
        }
        String thetemplate = usetemplate.getPath();
        LOG.log(Level.INFO, "template:{0}", thetemplate);
        extension = usetemplate.getFormat();
        if (extension == null || extension.isEmpty()) {
            extension = "html";
        }
        boolean bl = isOneEntity = indis.length + fams.length <= 1;
        if (isOneEntity) {
            this.isTodo = false;
        }
        LOG.log(Level.INFO, "tofile=" + this.saveReportToFile);
        if (!this.saveReportToFile) {
            try {
                file = File.createTempFile("Ancestris-", null);
            }
            catch (IOException ioe) {
                file = null;
            }
        } else {
            file = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, extension, "");
            if (file != null) {
                this.println(this.translate("output.file.msg", new Object[]{file.getAbsolutePath()}));
            }
        }
        if (file == null) {
            LOG.log(Level.INFO, "file = null");
            return null;
        }
        LOG.log(Level.INFO, "file=" + file);
        try {
            this.mydoc = new DocReport(file, this.gedartTemplates, this.theGedcom.getEncoding().toString());
            this.mydoc.put("options", this);
            this.mydoc.put("TEMPLATE", thetemplate);
        }
        catch (IOException ioe) {
            System.err.println("IO Exception!");
            ioe.printStackTrace();
            return null;
        }
        if (this.includeIndi) {
            this.println(this.translate("includeIndi.msg", new Object[]{indis.length}));
            this.mydoc.put("INDIS", indis);
        }
        if (this.includeFam) {
            this.println(this.translate("includeFam.msg", new Object[]{fams.length}));
            this.mydoc.put("FAMS", fams);
        }
        this.mydoc.put("GEDCOM", this.theGedcom);
        this.mydoc.render(thetemplate + "/index.vm");
        this.mydoc.close();
        long size = file.length();
        if (size > 500000L && DialogManager.OK_OPTION != DialogManager.create((String)this.translate("TITL_SizeWarning"), (String)this.translate("MSG_SizeWarning", new Object[]{size})).setMessageType(2).setOptionType(2).setDialogId("report.ReportGraphicalTree").show()) {
            this.println("Completed but file not opened as probably too big.");
            return null;
        }
        if (thetemplate.contains("A03_TreePretty")) {
            try {
                String resource = "oaktreeC.jpg";
                String source = "/ancestris/reports/gedart/templates/A03_TreePretty/" + resource;
                URL inputUrl = GedartTemplates.class.getResource(source);
                FileUtils.copyURLToFile((URL)inputUrl, (File)new File(file.getParentFile(), resource));
            }
            catch (IOException ex) {
                this.println("Failed to copy image. Error:" + ex.getMessage());
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.println(this.translate(this.saveReportToFile ? "completed.File" : "completed.noFile"));
        return file;
    }
}

