/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import genj.option.Sorter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SortManager
extends JPanel {
    private Sorter sorter;
    private DefaultListModel model;
    private JList<String> jList;
    private JScrollPane jScrollPane1;
    private JButton moveDownButton;
    private JButton moveUpButton;

    public SortManager() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jList);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/core/resources/images/MoveUp.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(SortManager.class, (String)"SortManager.moveUpButton.text"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortManager.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/core/resources/images/MoveDown.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(SortManager.class, (String)"SortManager.moveDownButton.text"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SortManager.this.moveDownButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 125, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.moveDownButton, -2, 38, Short.MAX_VALUE).addComponent(this.moveUpButton, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.moveItem(-1);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.moveItem(1);
    }

    public void setSort(Sorter sorter) {
        this.sorter = sorter;
        this.model = new DefaultListModel();
        for (Object o : sorter) {
            this.model.addElement(o);
        }
        this.jList.setModel(this.model);
        this.jList.setSelectedIndex(0);
        this.jList.setVisibleRowCount(Math.max(4, this.model.getSize()));
    }

    public Object getSort() {
        return this.sorter;
    }

    public String getStringValue() {
        return this.sorter == null ? "" : this.sorter.getStringOrderedValue();
    }

    private void moveItem(int i) {
        int index = this.jList.getSelectedIndex();
        Object item = this.model.remove(index);
        if (index + i < 0 || index + i > this.model.getSize()) {
            i = 0;
        }
        this.model.add(index + i, item);
        this.jList.setSelectedIndex(index + i);
        this.sorter.updateMap(this.model);
    }
}

