"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffStringIndex = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const read_1 = require("../cff-index/read");
const write_1 = require("../cff-index/write");
exports.CffStringIndex = {
    ...(0, bin_util_1.Read)((view, ctx) => {
        return view.next(new read_1.CffReadIndex({ read: (view, ctx, size) => view.bytes(size).toString("utf8") }), ctx);
    }),
    ...(0, bin_util_1.Write)((frag, strings, ctx) => {
        frag.push(new write_1.CffWriteIndex({
            write: (f, item, ctx) => f.bytes(Buffer.from(item, "utf8"))
        }), strings, ctx);
    })
};
//# sourceMappingURL=string-index.js.map