/**
 * \file pappsomspp/processing/cbor/psm/psmcborutils.cpp
 * \date 16/09/2025
 * \author Olivier Langella
 * \brief PSM CBOR utilities
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "psmcborutils.h"

namespace pappso
{
namespace cbor
{
namespace psm
{
void
PsmCborUtils::prepareCborScanWithSpectrum(
  QCborMap &cbor_scan, const pappso::QualifiedMassSpectrum &ms2_qualified_mass_spectrum)
{
  // id
  QCborMap cbor_scan_id;
  cbor_scan_id.insert(QString("index"),
                      (qint64)ms2_qualified_mass_spectrum.getMassSpectrumId().getSpectrumIndex());
  cbor_scan_id.insert(QString("native_id"),
                      ms2_qualified_mass_spectrum.getMassSpectrumId().getNativeId());
  cbor_scan.insert(QString("id"), cbor_scan_id.toCborValue());


  // precursor
  QCborMap cbor_scan_precursor;
  cbor_scan_id.insert(QString("z"), ms2_qualified_mass_spectrum.getPrecursorCharge());
  cbor_scan_id.insert(QString("mz"), ms2_qualified_mass_spectrum.getPrecursorMz());
  cbor_scan_id.insert(QString("mh"), ms2_qualified_mass_spectrum.getPrecursorMass());
  cbor_scan_id.insert(QString("intensity"), ms2_qualified_mass_spectrum.getPrecursorIntensity());
  cbor_scan.insert(QString("precursor"), cbor_scan_precursor.toCborValue());


  // ms2
  QCborMap cbor_scan_ms2;
  cbor_scan_ms2.insert(QString("rt"), ms2_qualified_mass_spectrum.getRtInSeconds());
  cbor_scan.insert(QString("ms2"), cbor_scan_ms2.toCborValue());
}
} // namespace psm
} // namespace cbor
} // namespace pappso
